/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

@Deprecated
public class ContextDeployer
extends AbstractLifeCycle {
    private int _scanInterval = 10;
    private Scanner _scanner;
    private ScannerListener _scannerListener;
    private Resource _contextsDir;
    private Map _currentDeployments = new HashMap();
    private ContextHandlerCollection _contexts;
    private ConfigurationManager _configMgr;
    private boolean _recursive = false;
    private AttributesMap _contextAttributes = new AttributesMap();

    public ContextDeployer() {
        Log.warn("ContextDeployer is deprecated. Use ContextProvider");
        this._scanner = new Scanner();
    }

    public ContextHandlerCollection getContexts() {
        return this._contexts;
    }

    public void setContexts(ContextHandlerCollection contexts) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot set Contexts after deployer start");
        }
        this._contexts = contexts;
    }

    public void setScanInterval(int seconds) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot change scan interval after deployer start");
        }
        this._scanInterval = seconds;
    }

    public int getScanInterval() {
        return this._scanInterval;
    }

    public void setContextsDir(String dir) {
        try {
            this._contextsDir = Resource.newResource(dir);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getContextsDir() {
        return this._contextsDir == null ? null : this._contextsDir.toString();
    }

    @Deprecated
    public void setConfigurationDir(String dir) throws Exception {
        this.setConfigurationDir(Resource.newResource(dir));
    }

    @Deprecated
    public void setConfigurationDir(File file) throws Exception {
        this.setConfigurationDir(Resource.newResource(file.toURL()));
    }

    @Deprecated
    public void setConfigurationDir(Resource resource) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot change hot deploy dir after deployer start");
        }
        this._contextsDir = resource;
    }

    @Deprecated
    public void setDirectory(String directory) throws Exception {
        this.setConfigurationDir(directory);
    }

    @Deprecated
    public String getDirectory() {
        return this.getConfigurationDir().getName();
    }

    @Deprecated
    public Resource getConfigurationDir() {
        return this._contextsDir;
    }

    public void setConfigurationManager(ConfigurationManager configMgr) {
        this._configMgr = configMgr;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configMgr;
    }

    public void setRecursive(boolean recursive) {
        this._recursive = recursive;
    }

    public boolean getRecursive() {
        return this._recursive;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public void setAttribute(String name, Object value) {
        this._contextAttributes.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this._contextAttributes.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._contextAttributes.removeAttribute(name);
    }

    private void deploy(String filename) throws Exception {
        ContextHandler context = this.createContext(filename);
        Log.info("Deploy " + filename + " -> " + context);
        this._contexts.addHandler(context);
        this._currentDeployments.put(filename, context);
        if (this._contexts.isStarted()) {
            context.start();
        }
    }

    private void undeploy(String filename) throws Exception {
        ContextHandler context = (ContextHandler)this._currentDeployments.get(filename);
        Log.info("Undeploy " + filename + " -> " + context);
        if (context == null) {
            return;
        }
        context.stop();
        this._contexts.removeHandler(context);
        this._currentDeployments.remove(filename);
    }

    private void redeploy(String filename) throws Exception {
        this.undeploy(filename);
        this.deploy(filename);
    }

    protected void doStart() throws Exception {
        if (this._contextsDir == null) {
            throw new IllegalStateException("No configuration dir specified");
        }
        if (this._contexts == null) {
            throw new IllegalStateException("No context handler collection specified for deployer");
        }
        this._scanner.setScanDir(this._contextsDir.getFile());
        this._scanner.setScanInterval(this.getScanInterval());
        this._scanner.setRecursive(this._recursive);
        this._scanner.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                try {
                    return name.endsWith(".xml");
                }
                catch (Exception e) {
                    Log.warn(e);
                    return false;
                }
            }
        });
        this._scannerListener = new ScannerListener();
        this._scanner.addListener(this._scannerListener);
        this._scanner.scan();
        this._scanner.start();
        this._contexts.getServer().getContainer().addBean(this._scanner);
    }

    protected void doStop() throws Exception {
        this._scanner.removeListener(this._scannerListener);
        this._scanner.stop();
    }

    private ContextHandler createContext(String filename) throws Exception {
        Resource resource = Resource.newResource(filename);
        if (!resource.exists()) {
            return null;
        }
        XmlConfiguration xmlConfiguration = new XmlConfiguration(resource.getURL());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("Server", this._contexts.getServer());
        if (this._configMgr != null) {
            properties.putAll(this._configMgr.getProperties());
        }
        xmlConfiguration.setProperties(properties);
        ContextHandler context = (ContextHandler)xmlConfiguration.configure();
        if (this._contextAttributes != null && this._contextAttributes.size() > 0) {
            AttributesMap attributes = new AttributesMap(this._contextAttributes);
            attributes.addAll(context.getAttributes());
            context.setAttributes(attributes);
        }
        return context;
    }

    protected class ScannerListener
    implements Scanner.DiscreteListener {
        protected ScannerListener() {
        }

        public void fileAdded(String filename) throws Exception {
            ContextDeployer.this.deploy(filename);
        }

        public void fileChanged(String filename) throws Exception {
            ContextDeployer.this.redeploy(filename);
        }

        public void fileRemoved(String filename) throws Exception {
            ContextDeployer.this.undeploy(filename);
        }

        public String toString() {
            return "ContextDeployer$Scanner";
        }
    }
}

