/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.IntrospectionUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    protected WebAppContext _wac;

    public ResourceAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        Class clazz = null;
        try {
            clazz = Loader.loadClass(null, className);
        }
        catch (Exception e) {
            Log.warn(e);
        }
        if (!Util.isServletType(clazz)) {
            Log.debug("Ignoring @Resource annotation on on-servlet type class " + clazz.getName());
            return;
        }
        Resource resource = clazz.getAnnotation(Resource.class);
        if (resource != null) {
            String name = resource.name();
            String mappedName = resource.mappedName();
            Resource.AuthenticationType auth = resource.authenticationType();
            Class type = resource.type();
            boolean shareable = resource.shareable();
            if (name == null || name.trim().equals("")) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                if (!NamingEntryUtil.bindToENC(this._wac, name, mappedName) && !NamingEntryUtil.bindToENC(this._wac.getServer(), name, mappedName)) {
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
            }
            catch (NamingException e) {
                Log.warn(e);
            }
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        block20: {
            InjectionCollection injections = (InjectionCollection)this._wac.getAttribute("org.eclipse.jetty.injectionCollection");
            Class clazz = null;
            try {
                clazz = Loader.loadClass(null, className);
                Field f = clazz.getDeclaredField(fieldName);
                if (!Util.isServletType(clazz)) {
                    Log.debug("Ignoring @Resource annotation on on-servlet type field " + fieldName);
                    return;
                }
                Resource resource = f.getAnnotation(Resource.class);
                if (resource == null) {
                    return;
                }
                if (Modifier.isStatic(f.getModifiers())) {
                    throw new IllegalStateException(f + " cannot be static");
                }
                if (Modifier.isFinal(f.getModifiers())) {
                    throw new IllegalStateException(f + " cannot be final");
                }
                String name = f.getDeclaringClass().getCanonicalName() + "/" + f.getName();
                name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
                Class<?> type = f.getType();
                if (resource.type() != null && !resource.type().equals(Object.class) && !IntrospectionUtil.isTypeCompatible(type, resource.type(), false)) {
                    throw new IllegalStateException("@Resource incompatible type=" + resource.type() + " with field type =" + f.getType());
                }
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
                Resource.AuthenticationType auth = resource.authenticationType();
                boolean shareable = resource.shareable();
                Injection webXmlInjection = injections.getInjection(f.getDeclaringClass(), f);
                if (webXmlInjection == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC(this._wac, name, mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(this._wac.getServer(), name, mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, name, mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                String nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            Log.debug("Bound " + (mappedName == null ? name : mappedName) + " as " + name);
                            Injection injection = new Injection();
                            injection.setTargetClass(f.getDeclaringClass());
                            injection.setJndiName(name);
                            injection.setMappingName(mappedName);
                            injection.setTarget(f);
                            injections.add(injection);
                        } else if (!Util.isEnvEntryType(type)) {
                            throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                        }
                        break block20;
                    }
                    catch (NamingException e) {
                        if (!Util.isEnvEntryType(type)) {
                            throw new IllegalStateException(e);
                        }
                        break block20;
                    }
                }
                Object val = webXmlInjection.lookupInjectedValue();
                if (!IntrospectionUtil.isTypeCompatible(type, value.getClass(), false)) {
                    throw new IllegalStateException("Type of field=" + type + " is not compatible with Resource type=" + val.getClass());
                }
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        block20: {
            InjectionCollection injections = (InjectionCollection)this._wac.getAttribute("org.eclipse.jetty.injectionCollection");
            Class clazz = null;
            try {
                clazz = Loader.loadClass(null, className);
                Class[] args = Util.convertTypes(params);
                Method m = clazz.getDeclaredMethod(methodName, args);
                if (!Util.isServletType(m.getDeclaringClass())) {
                    Log.debug("Ignoring @Resource annotation on on-servlet type method " + m.getName());
                    return;
                }
                Resource resource = m.getAnnotation(Resource.class);
                if (resource == null) {
                    return;
                }
                if (Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(m + " cannot be static");
                }
                if (!IntrospectionUtil.isJavaBeanCompliantSetter(m)) {
                    throw new IllegalStateException(m + " is not a java bean compliant setter method");
                }
                String name = m.getName().substring(3);
                name = name.substring(0, 1).toLowerCase() + name.substring(1);
                name = m.getDeclaringClass().getCanonicalName() + "/" + name;
                name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
                Class<?> type = m.getParameterTypes()[0];
                Resource.AuthenticationType auth = resource.authenticationType();
                boolean shareable = resource.shareable();
                if (resource.type() != null && !resource.type().equals(Object.class) && !IntrospectionUtil.isTypeCompatible(type, resource.type(), false)) {
                    throw new IllegalStateException("@Resource incompatible type=" + resource.type() + " with method param=" + type + " for " + m);
                }
                Injection webXmlInjection = injections.getInjection(m.getDeclaringClass(), m);
                if (webXmlInjection == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC(this._wac, name, mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(this._wac.getServer(), name, mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, name, mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                String nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            Log.debug("Bound " + (mappedName == null ? name : mappedName) + " as " + name);
                            Injection injection = new Injection();
                            injection.setTargetClass(m.getDeclaringClass());
                            injection.setJndiName(name);
                            injection.setMappingName(mappedName);
                            injection.setTarget(m);
                            injections.add(injection);
                        } else if (!Util.isEnvEntryType(type)) {
                            throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                        }
                        break block20;
                    }
                    catch (NamingException e) {
                        if (!Util.isEnvEntryType(type)) {
                            throw new IllegalStateException(e);
                        }
                        break block20;
                    }
                }
                Object value = webXmlInjection.lookupInjectedValue();
                if (!IntrospectionUtil.isTypeCompatible(type, value.getClass(), false)) {
                    throw new IllegalStateException("Type of field=" + type + " is not compatible with Resource type=" + value.getClass());
                }
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }
}

