/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import org.eclipse.jetty.annotations.AbstractConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.PostConstructAnnotationHandler;
import org.eclipse.jetty.annotations.PreDestroyAnnotationHandler;
import org.eclipse.jetty.annotations.ResourceAnnotationHandler;
import org.eclipse.jetty.annotations.ResourcesAnnotationHandler;
import org.eclipse.jetty.annotations.RunAsAnnotationHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class AnnotationConfiguration
extends AbstractConfiguration {
    public static final String CLASS_INHERITANCE_MAP = "org.eclipse.jetty.classInheritanceMap";

    public void preConfigure(WebAppContext context) throws Exception {
    }

    public void configure(WebAppContext context) throws Exception {
        int webxmlVersion;
        Boolean b = (Boolean)context.getAttribute("org.eclipse.jetty.metadataComplete");
        boolean metadataComplete = b != null && b != false;
        Integer i = (Integer)context.getAttribute("org.eclipse.jetty.webXmlVersion");
        int n = webxmlVersion = i == null ? 0 : i;
        if (metadataComplete) {
            if (Log.isDebugEnabled()) {
                Log.debug("Metadata-complete==true,  not processing annotations for context " + context);
            }
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("parsing annotations");
        }
        AnnotationParser parser = new AnnotationParser();
        parser.registerAnnotationHandler("javax.annotation.Resource", new ResourceAnnotationHandler(context));
        parser.registerAnnotationHandler("javax.annotation.Resources", new ResourcesAnnotationHandler(context));
        parser.registerAnnotationHandler("javax.annotation.PostConstruct", new PostConstructAnnotationHandler(context));
        parser.registerAnnotationHandler("javax.annotation.PreDestroy", new PreDestroyAnnotationHandler(context));
        parser.registerAnnotationHandler("javax.annotation.security.RunAs", new RunAsAnnotationHandler(context));
        ClassInheritanceHandler classHandler = new ClassInheritanceHandler();
        parser.registerClassHandler(classHandler);
        if (webxmlVersion >= 30 || context.isConfigurationDiscovered()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Scanning all classes for annotations: webxmlVersion=" + webxmlVersion + " configurationDiscovered=" + context.isConfigurationDiscovered());
            }
            this.parseContainerPath(context, parser);
            this.parseWebInfLib(context, parser);
            this.parseWebInfClasses(context, parser);
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug("Scanning only classes in web.xml for annotations");
            }
            this.parse25Classes(context, parser);
        }
        context.setAttribute(CLASS_INHERITANCE_MAP, classHandler.getMap());
    }

    public void deconfigure(WebAppContext context) throws Exception {
    }

    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(CLASS_INHERITANCE_MAP, null);
    }
}

