/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;

public class DeferredAuthentication
implements Authentication.Deferred {
    protected final Authenticator _authenticator;
    private LoginService _loginService;
    private IdentityService _identityService;
    private Object _previousAssociation;
    static HttpServletResponse __deferredResponse = new HttpServletResponse(){

        public void addCookie(Cookie cookie) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void addHeader(String name, String value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }

        public void setStatus(int sc, String sm) {
        }

        public void flushBuffer() throws IOException {
        }

        public int getBufferSize() {
            return 1024;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return __nullOut;
        }

        public PrintWriter getWriter() throws IOException {
            return IO.getNullPrintWriter();
        }

        public boolean isCommitted() {
            return true;
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int size) {
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentType(String type) {
        }

        public void setLocale(Locale loc) {
        }

        public Collection<String> getHeaderNames() {
            return Collections.emptyList();
        }

        public String getHeader(String arg0) {
            return null;
        }

        public Collection<String> getHeaders(String arg0) {
            return Collections.emptyList();
        }

        public int getStatus() {
            return 0;
        }
    };
    private static ServletOutputStream __nullOut = new ServletOutputStream(){

        public void write(int b) throws IOException {
        }

        public void print(String s) throws IOException {
        }

        public void println(String s) throws IOException {
        }
    };

    public DeferredAuthentication(Authenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    public DeferredAuthentication(LoginAuthenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this._identityService = identityService;
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }

    @Override
    public Authentication authenticate(ServletRequest request) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, (ServletResponse)__deferredResponse, true);
            if (authentication != null && authentication instanceof Authentication.User && !(authentication instanceof Authentication.ResponseSent)) {
                if (this._identityService != null) {
                    this._previousAssociation = this._identityService.associate(((Authentication.User)authentication).getUserIdentity());
                }
                return authentication;
            }
        }
        catch (ServerAuthException e) {
            Log.debug(e);
        }
        return this;
    }

    @Override
    public Authentication authenticate(ServletRequest request, ServletResponse response) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, response, true);
            if (authentication instanceof Authentication.User && this._identityService != null) {
                this._previousAssociation = this._identityService.associate(((Authentication.User)authentication).getUserIdentity());
            }
            return authentication;
        }
        catch (ServerAuthException e) {
            Log.debug(e);
            return this;
        }
    }

    @Override
    public Authentication login(String username, String password) {
        UserIdentity user;
        if (this._loginService != null && (user = this._loginService.login(username, password)) != null) {
            UserAuthentication authentication = new UserAuthentication("API", user);
            if (this._identityService != null) {
                this._previousAssociation = this._identityService.associate(user);
            }
            return authentication;
        }
        return null;
    }

    public Object getPreviousAssociation() {
        return this._previousAssociation;
    }

    public boolean isDeferred(HttpServletResponse response) {
        return response == __deferredResponse;
    }
}

