/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nested;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.nested.NestedConnector;
import org.eclipse.jetty.nested.NestedEndPoint;
import org.eclipse.jetty.nested.NestedGenerator;
import org.eclipse.jetty.nested.NestedParser;
import org.eclipse.jetty.nested.NestedRequest;
import org.eclipse.jetty.server.HttpConnection;

public class NestedConnection
extends HttpConnection {
    protected NestedConnection(NestedConnector connector, NestedEndPoint endp, HttpServletRequest outerRequest, HttpServletResponse outerResponse, String nestedIn) throws IOException {
        super(connector, endp, connector.getServer(), new NestedParser(), new NestedGenerator(connector.getResponseBuffers(), endp, outerResponse, nestedIn), new NestedRequest(outerRequest));
        ((NestedRequest)this._request).setConnection(this);
        this._request.setDispatcherType(DispatcherType.REQUEST);
        this._request.setScheme(outerRequest.getScheme());
        this._request.setMethod(outerRequest.getMethod());
        String uri = outerRequest.getQueryString() == null ? outerRequest.getRequestURI() : outerRequest.getRequestURI() + "?" + outerRequest.getQueryString();
        this._request.setUri(new HttpURI(uri));
        this._request.setPathInfo(outerRequest.getRequestURI());
        this._request.setQueryString(outerRequest.getQueryString());
        this._request.setProtocol(outerRequest.getProtocol());
        HttpFields fields = this.getRequestFields();
        Enumeration e = outerRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            String value = outerRequest.getHeader(header);
            fields.add(header, value);
        }
        this._request.setCookies(outerRequest.getCookies());
        e = outerRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            String attr = (String)e.nextElement();
            this._request.setAttribute(attr, outerRequest.getAttribute(attr));
        }
        connector.customize(endp, this._request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void service() throws IOException, ServletException {
        NestedConnection.setCurrentConnection(this);
        try {
            this.getServer().handle(this);
            this.completeResponse();
            this._generator.flushBuffer();
            this._endp.flush();
        }
        finally {
            NestedConnection.setCurrentConnection(null);
        }
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return ((NestedEndPoint)this._endp).getServletInputStream();
    }

    @Override
    public Connection handle() throws IOException {
        throw new IllegalStateException();
    }
}

