/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.websocket.AbstractExtension;

public class FragmentExtension
extends AbstractExtension {
    private int _maxLength = -1;
    private int _minFragments = 1;

    public FragmentExtension() {
        super("fragment", 0, 0, 0);
    }

    @Override
    public boolean init(Map<String, String> parameters) {
        if (super.init(parameters)) {
            this._maxLength = this.getInitParameter("maxLength", this._maxLength);
            this._minFragments = this.getInitParameter("minFragments", this._minFragments);
            return true;
        }
        return false;
    }

    @Override
    public void addFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
        if (this.getConnection().isControl(opcode)) {
            super.addFrame(flags, opcode, content, offset, length);
            return;
        }
        int fragments = 1;
        while (this._maxLength > 0 && length > this._maxLength) {
            ++fragments;
            super.addFrame((byte)(flags & ~this.getConnection().finMask()), opcode, content, offset, this._maxLength);
            length -= this._maxLength;
            offset += this._maxLength;
            opcode = this.getConnection().continuationOpcode();
        }
        while (fragments < this._minFragments) {
            int frag = length / 2;
            ++fragments;
            super.addFrame((byte)(flags & 7), opcode, content, offset, frag);
            length -= frag;
            offset += frag;
            opcode = this.getConnection().continuationOpcode();
        }
        super.addFrame((byte)(flags | this.getConnection().finMask()), opcode, content, offset, length);
    }
}

