/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketParser;

public class AbstractExtension
implements Extension {
    private final String _name;
    private final byte[] _dataOpcodes;
    private final byte[] _controlOpcodes;
    private final byte[] _bitMasks;
    private final Map<String, String> _parameters = new HashMap<String, String>();
    private WebSocketParser.FrameHandler _inbound;
    private WebSocketGenerator _outbound;
    private WebSocket.FrameConnection _connection;

    public AbstractExtension(String name, int dataCodes, int controlCodes, int flags) {
        this._name = name;
        this._dataOpcodes = new byte[dataCodes];
        this._controlOpcodes = new byte[controlCodes];
        this._bitMasks = new byte[flags];
    }

    @Override
    public int getDataOpcodes() {
        return this._dataOpcodes.length;
    }

    @Override
    public int getControlOpcodes() {
        return this._controlOpcodes.length;
    }

    @Override
    public int getReservedBits() {
        return this._bitMasks.length;
    }

    public WebSocket.FrameConnection getConnection() {
        return this._connection;
    }

    @Override
    public boolean init(Map<String, String> parameters) {
        this._parameters.putAll(parameters);
        return true;
    }

    public String getInitParameter(String name) {
        return this._parameters.get(name);
    }

    public String getInitParameter(String name, String dft) {
        if (!this._parameters.containsKey(name)) {
            return dft;
        }
        return this._parameters.get(name);
    }

    public int getInitParameter(String name, int dft) {
        String v = this._parameters.get(name);
        if (v == null) {
            return dft;
        }
        return Integer.valueOf(v);
    }

    @Override
    public void bind(WebSocket.FrameConnection connection, WebSocketParser.FrameHandler incoming, WebSocketGenerator outgoing, byte[] dataOpcodes, byte[] controlOpcodes, byte[] bitMasks) {
        this._connection = connection;
        this._inbound = incoming;
        this._outbound = outgoing;
        if (dataOpcodes != null) {
            System.arraycopy(dataOpcodes, 0, this._dataOpcodes, 0, dataOpcodes.length);
        }
        if (controlOpcodes != null) {
            System.arraycopy(controlOpcodes, 0, this._dataOpcodes, 0, controlOpcodes.length);
        }
        if (bitMasks != null) {
            System.arraycopy(bitMasks, 0, this._bitMasks, 0, bitMasks.length);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getParameterizedName() {
        StringBuilder name = new StringBuilder();
        name.append(this._name);
        for (String param : this._parameters.keySet()) {
            name.append(';').append(param).append('=').append(QuotedStringTokenizer.quoteIfNeeded(this._parameters.get(param), ";="));
        }
        return name.toString();
    }

    @Override
    public void onFrame(byte flags, byte opcode, Buffer buffer) {
        this._inbound.onFrame(flags, opcode, buffer);
    }

    @Override
    public void close(int code, String message) {
        this._inbound.close(code, message);
    }

    @Override
    public int flush() throws IOException {
        return this._outbound.flush();
    }

    @Override
    public boolean isBufferEmpty() {
        return this._outbound.isBufferEmpty();
    }

    @Override
    public void addFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
        this._outbound.addFrame(flags, opcode, content, offset, length);
    }

    public byte dataOpcode(int i) {
        return this._dataOpcodes[i];
    }

    public int dataIndex(byte op) {
        for (int i = 0; i < this._dataOpcodes.length; ++i) {
            if (this._dataOpcodes[i] != op) continue;
            return i;
        }
        return -1;
    }

    public byte controlOpcode(int i) {
        return this._dataOpcodes[i];
    }

    public int controlIndex(byte op) {
        for (int i = 0; i < this._controlOpcodes.length; ++i) {
            if (this._controlOpcodes[i] != op) continue;
            return i;
        }
        return -1;
    }

    public byte setFlag(byte flags, int flag) {
        return (byte)(flags | this._bitMasks[flag]);
    }

    public byte clearFlag(byte flags, int flag) {
        return (byte)(flags & ~this._bitMasks[flag]);
    }

    public boolean isFlag(byte flags, int flag) {
        return (flags & this._bitMasks[flag]) != 0;
    }

    public String toString() {
        return this.getParameterizedName();
    }
}

