/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.MultiPartInputStream;

public class MultiPartFilter
implements Filter {
    private static final String FILES = "org.eclipse.jetty.servlet.MultiPartFilter.files";
    private File tempdir;
    private boolean _deleteFiles;
    private ServletContext _context;
    private int _fileOutputBuffer = 0;
    private long _maxFileSize = -1L;
    private long _maxRequestSize = -1L;

    public void init(FilterConfig filterConfig) throws ServletException {
        String maxRequestSize;
        String maxFileSize;
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this._deleteFiles = "true".equals(filterConfig.getInitParameter("deleteFiles"));
        String fileOutputBuffer = filterConfig.getInitParameter("fileOutputBuffer");
        if (fileOutputBuffer != null) {
            this._fileOutputBuffer = Integer.parseInt(fileOutputBuffer);
        }
        if ((maxFileSize = filterConfig.getInitParameter("maxFileSize")) != null) {
            this._maxFileSize = Long.parseLong(maxFileSize.trim());
        }
        if ((maxRequestSize = filterConfig.getInitParameter("maxRequestSize")) != null) {
            this._maxRequestSize = Long.parseLong(maxRequestSize.trim());
        }
        this._context = filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain.doFilter(request, response);
            return;
        }
        BufferedInputStream in = new BufferedInputStream((InputStream)request.getInputStream());
        String content_type = srequest.getContentType();
        MultiMap params = new MultiMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String[]) {
                params.addValues(entry.getKey(), (String[])value);
                continue;
            }
            params.add(entry.getKey(), value);
        }
        MultipartConfigElement config = new MultipartConfigElement(this.tempdir.getCanonicalPath(), this._maxFileSize, this._maxRequestSize, this._fileOutputBuffer);
        MultiPartInputStream mpis = new MultiPartInputStream(in, content_type, config, this.tempdir);
        try {
            Collection<Part> parts = mpis.getParts();
            if (parts != null) {
                for (Part p : parts) {
                    MultiPartInputStream.MultiPart mp = (MultiPartInputStream.MultiPart)p;
                    if (mp.getFile() != null) {
                        request.setAttribute(mp.getName(), (Object)mp.getFile());
                        if (mp.getContentDispositionFilename() != null) {
                            params.add(mp.getName(), mp.getContentDispositionFilename());
                        }
                        if (!this._deleteFiles) continue;
                        mp.getFile().deleteOnExit();
                        ArrayList<File> files = (ArrayList<File>)request.getAttribute(FILES);
                        if (files == null) {
                            files = new ArrayList<File>();
                            request.setAttribute(FILES, files);
                        }
                        files.add(mp.getFile());
                        continue;
                    }
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    IO.copy(p.getInputStream(), bytes);
                    params.add(p.getName(), bytes.toByteArray());
                }
            }
            chain.doFilter((ServletRequest)new Wrapper(srequest, params), response);
        }
        finally {
            this.deleteFiles(request);
        }
    }

    private void deleteFiles(ServletRequest request) {
        ArrayList files = (ArrayList)request.getAttribute(FILES);
        if (files != null) {
            for (File file : files) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    this._context.log("failed to delete " + file, (Throwable)e);
                }
            }
        }
    }

    private String value(String nameEqualsValue) {
        return nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
    }

    public void destroy() {
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String _encoding = "UTF-8";
        MultiMap _params;

        public Wrapper(HttpServletRequest request, MultiMap map) {
            super(request);
            this._params = map;
        }

        public int getContentLength() {
            return 0;
        }

        public String getParameter(String name) {
            Object o = this._params.get(name);
            if (!(o instanceof byte[]) && LazyList.size(o) > 0) {
                o = LazyList.get(o, 0);
            }
            if (o instanceof byte[]) {
                try {
                    String s = new String((byte[])o, this._encoding);
                    return s;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (o != null) {
                return String.valueOf(o);
            }
            return null;
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(this._params.toStringArrayMap());
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this._params.keySet());
        }

        public String[] getParameterValues(String name) {
            List l = this._params.getValues(name);
            if (l == null || l.size() == 0) {
                return new String[0];
            }
            String[] v = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (o instanceof byte[]) {
                    try {
                        v[i] = new String((byte[])o, this._encoding);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(o instanceof String)) continue;
                v[i] = (String)o;
            }
            return v;
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this._encoding = enc;
        }
    }
}

