/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.EventListener;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebListenerAnnotation
extends DiscoveredAnnotation {
    public WebListenerAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    @Override
    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            Log.warn(this._className + " cannot be loaded");
            return;
        }
        try {
            if (ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz)) {
                EventListener listener = (EventListener)clazz.newInstance();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOrigin(clazz.getName() + ".listener") == MetaData.Origin.NotSet) {
                    this._context.addEventListener(listener);
                }
            } else {
                Log.warn(clazz.getName() + " does not implement one of the servlet listener interfaces");
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }
}

