/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PreDestroy;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.webapp.WebAppContext;

public class PreDestroyAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    WebAppContext _wac;
    LifeCycleCallbackCollection _callbacks;

    public PreDestroyAnnotationHandler(WebAppContext wac) {
        super(true);
        this._wac = wac;
        this._callbacks = (LifeCycleCallbackCollection)this._wac.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
    }

    @Override
    public void doHandle(Class clazz) {
        if (Util.isServletType(clazz)) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.isAnnotationPresent(PreDestroy.class)) continue;
                if (m.getParameterTypes().length != 0) {
                    throw new IllegalStateException(m + " has parameters");
                }
                if (m.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(m + " is not void");
                }
                if (m.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(m + " throws checked exceptions");
                }
                if (Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(m + " is static");
                }
                PreDestroyCallback callback = new PreDestroyCallback();
                callback.setTarget(clazz.getName(), m.getName());
                this._callbacks.add(callback);
            }
        }
    }
}

