/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.plus.annotation.RunAs;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAsAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    protected WebAppContext _wac;

    public RunAsAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        RunAsCollection runAsCollection = (RunAsCollection)this._wac.getAttribute("org.eclipse.jetty.runAsCollection");
        Class clazz = null;
        try {
            String role;
            clazz = Loader.loadClass(null, className);
            if (!Servlet.class.isAssignableFrom(clazz)) {
                Log.debug("@RunAs annotation ignored on on-servlet class " + clazz.getName());
                return;
            }
            javax.annotation.security.RunAs runAs = clazz.getAnnotation(javax.annotation.security.RunAs.class);
            if (runAs != null && (role = runAs.value()) != null) {
                RunAs ra = new RunAs();
                ra.setTargetClass(clazz);
                ra.setRoleName(role);
                runAsCollection.add(ra);
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@RunAs annotation not applicable for fields: " + className + "." + fieldName);
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@RunAs annotation ignored on method: " + className + "." + methodName + " " + signature);
    }
}

