/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.log.Log;

public class MBeanContainer
extends AbstractLifeCycle
implements Container.Listener {
    private final MBeanServer _server;
    private final WeakHashMap _beans = new WeakHashMap();
    private final HashMap _unique = new HashMap();
    private String _domain = null;
    private MultiMap _relations = new MultiMap();

    public synchronized ObjectName findMBean(Object object) {
        ObjectName bean = (ObjectName)this._beans.get(object);
        return bean == null ? null : bean;
    }

    public synchronized Object findBean(ObjectName oname) {
        for (Map.Entry entry : this._beans.entrySet()) {
            ObjectName bean = (ObjectName)entry.getValue();
            if (!bean.equals(oname)) continue;
            return entry.getKey();
        }
        return null;
    }

    public MBeanContainer(MBeanServer server) {
        this._server = server;
    }

    public MBeanServer getMBeanServer() {
        return this._server;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    public void doStart() {
    }

    public synchronized void add(Container.Relationship relationship) {
        ObjectName child;
        ObjectName parent = (ObjectName)this._beans.get(relationship.getParent());
        if (parent == null) {
            this.addBean(relationship.getParent());
            parent = (ObjectName)this._beans.get(relationship.getParent());
        }
        if ((child = (ObjectName)this._beans.get(relationship.getChild())) == null) {
            this.addBean(relationship.getChild());
            child = (ObjectName)this._beans.get(relationship.getChild());
        }
        if (parent != null && child != null) {
            this._relations.add(parent, relationship);
        }
    }

    public synchronized void remove(Container.Relationship relationship) {
        ObjectName parent = (ObjectName)this._beans.get(relationship.getParent());
        ObjectName child = (ObjectName)this._beans.get(relationship.getChild());
        if (parent != null && child != null) {
            this._relations.removeValue(parent, relationship);
        }
    }

    public synchronized void removeBean(Object obj) {
        ObjectName bean = (ObjectName)this._beans.remove(obj);
        if (bean != null) {
            List r = this._relations.getValues(bean);
            if (r != null && r.size() > 0) {
                Log.debug("Unregister {}", r);
                for (Container.Relationship rel : new ArrayList(r)) {
                    rel.getContainer().update(rel.getParent(), rel.getChild(), null, rel.getRelationship(), true);
                }
            }
            try {
                this._server.unregisterMBean(bean);
                Log.debug("Unregistered {}", bean);
            }
            catch (InstanceNotFoundException e) {
                Log.ignore(e);
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }

    public synchronized void addBean(Object obj) {
        try {
            if (obj == null || this._beans.containsKey(obj)) {
                return;
            }
            Object mbean = ObjectMBean.mbeanFor(obj);
            if (mbean == null) {
                return;
            }
            ObjectName oname = null;
            if (mbean instanceof ObjectMBean) {
                ((ObjectMBean)mbean).setMBeanContainer(this);
                oname = ((ObjectMBean)mbean).getObjectName();
            }
            if (oname == null) {
                String type = obj.getClass().getName().toLowerCase();
                int dot = type.lastIndexOf(46);
                if (dot >= 0) {
                    type = type.substring(dot + 1);
                }
                String name = null;
                if (mbean instanceof ObjectMBean && (name = ((ObjectMBean)mbean).getObjectNameBasis()) != null) {
                    int slash;
                    if ((name = name.replace('\\', '/')).endsWith("/")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    if ((slash = name.lastIndexOf(47, name.length() - 1)) > 0) {
                        name = name.substring(slash + 1);
                    }
                    if ((dot = name.lastIndexOf(46)) > 0) {
                        name = name.substring(0, dot);
                    }
                    name = name.replace(':', '_').replace('*', '_').replace('?', '_').replace('=', '_').replace(',', '_').replace(' ', '_');
                }
                String basis = name != null && name.length() > 1 ? "type=" + type + ",name=" + name : "type=" + type;
                Integer count = (Integer)this._unique.get(basis);
                count = TypeUtil.newInteger(count == null ? 0 : 1 + count);
                this._unique.put(basis, count);
                String domain = this._domain;
                if (domain == null) {
                    domain = obj.getClass().getPackage().getName();
                }
                oname = ObjectName.getInstance(domain + ":" + basis + ",id=" + count);
            }
            ObjectInstance oinstance = this._server.registerMBean(mbean, oname);
            Log.debug("Registered {}", oinstance.getObjectName());
            this._beans.put(obj, oinstance.getObjectName());
        }
        catch (Exception e) {
            Log.warn("bean: " + obj, e);
        }
    }

    public void doStop() {
        while (this._beans.size() > 0) {
            this.removeBean(this._beans.keySet().iterator().next());
        }
    }

    private class ShutdownHook
    extends Thread {
        private final ObjectName mletName;
        private final ObjectName adaptorName;
        private final ObjectName processorName;

        public ShutdownHook(ObjectName mletName, ObjectName adaptorName, ObjectName processorName) {
            this.mletName = mletName;
            this.adaptorName = adaptorName;
            this.processorName = processorName;
        }

        public void run() {
            this.halt();
            this.unregister(this.processorName);
            this.unregister(this.adaptorName);
            this.unregister(this.mletName);
        }

        private void halt() {
            try {
                MBeanContainer.this._server.invoke(this.adaptorName, "stop", null, null);
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }

        private void unregister(ObjectName objectName) {
            try {
                MBeanContainer.this._server.unregisterMBean(objectName);
                Log.debug("Unregistered " + objectName);
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }
}

