/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.security;

import java.io.IOException;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.security.Authorization;
import org.eclipse.jetty.client.security.Realm;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.security.B64Code;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.StringUtil;

public class BasicAuthorization
implements Authorization {
    private Buffer _authorization;

    public BasicAuthorization(Realm realm) throws IOException {
        String authenticationString = "Basic " + B64Code.encode(realm.getPrincipal() + ":" + realm.getCredentials(), StringUtil.__ISO_8859_1);
        this._authorization = new ByteArrayBuffer(authenticationString);
    }

    public void setCredentials(HttpExchange exchange) throws IOException {
        exchange.setRequestHeader(HttpHeaders.AUTHORIZATION_BUFFER, this._authorization);
    }
}

