/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.log.Log;

public class SocketConnector
extends AbstractConnector {
    protected ServerSocket _serverSocket;
    protected final Set _connections = new HashSet();

    public Object getConnection() {
        return this._serverSocket;
    }

    public void open() throws IOException {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            this._serverSocket = this.newServerSocket(this.getHost(), this.getPort(), this.getAcceptQueueSize());
        }
        this._serverSocket.setReuseAddress(this.getReuseAddress());
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        ServerSocket ss = host == null ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, InetAddress.getByName(host));
        return ss;
    }

    public void close() throws IOException {
        if (this._serverSocket != null) {
            this._serverSocket.close();
        }
        this._serverSocket = null;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        Connection connection = new Connection(socket);
        connection.dispatch();
    }

    protected HttpConnection newHttpConnection(EndPoint endpoint) {
        return new HttpConnection(this, endpoint, this.getServer());
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        int lrmit;
        Connection connection = (Connection)endpoint;
        int n = lrmit = this.isLowResources() ? this._lowResourceMaxIdleTime : this._maxIdleTime;
        if (connection._sotimeout != lrmit) {
            connection._sotimeout = lrmit;
            ((Socket)endpoint.getTransport()).setSoTimeout(lrmit);
        }
        super.customize(endpoint, request);
    }

    public int getLocalPort() {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            return -1;
        }
        return this._serverSocket.getLocalPort();
    }

    protected void doStart() throws Exception {
        this._connections.clear();
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        HashSet set = null;
        Set set2 = this._connections;
        synchronized (set2) {
            set = new HashSet(this._connections);
        }
        for (Connection connection : set) {
            connection.close();
        }
    }

    protected class Connection
    extends SocketEndPoint
    implements Runnable {
        boolean _dispatched;
        HttpConnection _connection;
        int _sotimeout;
        protected Socket _socket;

        public Connection(Socket socket) throws IOException {
            super(socket);
            this._dispatched = false;
            this._connection = SocketConnector.this.newHttpConnection(this);
            this._sotimeout = socket.getSoTimeout();
            this._socket = socket;
        }

        public void dispatch() throws IOException {
            if (SocketConnector.this.getThreadPool() == null || !SocketConnector.this.getThreadPool().dispatch(this)) {
                Log.warn("dispatch failed for {}", this._connection);
                this.close();
            }
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.close();
            }
            return l;
        }

        public void close() throws IOException {
            this._connection.getRequest().getAsyncContinuation().cancel();
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    SocketConnector.this.connectionOpened(this._connection);
                    Set set = SocketConnector.this._connections;
                    synchronized (set) {
                        SocketConnector.this._connections.add(this);
                    }
                    while (SocketConnector.this.isStarted() && !this.isClosed()) {
                        int lrmit;
                        if (this._connection.isIdle() && SocketConnector.this.isLowResources() && (lrmit = SocketConnector.this.getLowResourceMaxIdleTime()) >= 0 && this._sotimeout != lrmit) {
                            this._sotimeout = lrmit;
                            this._socket.setSoTimeout(this._sotimeout);
                        }
                        this._connection.handle();
                    }
                    Object var4_6 = null;
                }
                catch (EofException e) {
                    Log.debug("EOF", e);
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        Log.ignore(e2);
                    }
                    Object var4_7 = null;
                    SocketConnector.this.connectionClosed(this._connection);
                    Set set = SocketConnector.this._connections;
                    synchronized (set) {
                        SocketConnector.this._connections.remove(this);
                        return;
                    }
                }
                catch (HttpException e) {
                    Log.debug("BAD", e);
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        Log.ignore(e2);
                    }
                    Object var4_8 = null;
                    SocketConnector.this.connectionClosed(this._connection);
                    Set set = SocketConnector.this._connections;
                    synchronized (set) {
                        SocketConnector.this._connections.remove(this);
                        return;
                    }
                }
                catch (Exception e) {
                    Log.warn("handle failed?", e);
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        Log.ignore(e2);
                    }
                    Object var4_9 = null;
                    SocketConnector.this.connectionClosed(this._connection);
                    Set set = SocketConnector.this._connections;
                    synchronized (set) {
                        SocketConnector.this._connections.remove(this);
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                SocketConnector.this.connectionClosed(this._connection);
                Set set = SocketConnector.this._connections;
                synchronized (set) {
                    SocketConnector.this._connections.remove(this);
                    throw throwable;
                }
            }
            SocketConnector.this.connectionClosed(this._connection);
            Set set = SocketConnector.this._connections;
            synchronized (set) {
                SocketConnector.this._connections.remove(this);
                return;
            }
        }
    }
}

