/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.JUnitPreferencesConstants;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.unittest.junit.JUnitTestPlugin;
import org.eclipse.jdt.ui.unittest.junit.launcher.JUnitRemoteTestRunnerClient;
import org.eclipse.jdt.ui.unittest.junit.ui.JUnitMessages;
import org.eclipse.jdt.ui.unittest.junit.ui.OpenEditorAtLineAction;
import org.eclipse.jdt.ui.unittest.junit.ui.OpenTestAction;
import org.eclipse.jdt.ui.unittest.junit.ui.ShowStackTraceInConsoleViewActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.unittest.launcher.ITestRunnerClient;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;
import org.eclipse.unittest.ui.ITestViewSupport;

public class JUnitTestViewSupport
implements ITestViewSupport {
    public static final String FRAME_LINE_PREFIX = "at ";

    public Collection<StringMatcher> getTraceExclusionFilterPatterns() {
        return Arrays.stream(JUnitPreferencesConstants.parseList((String)Platform.getPreferencesService().getString("org.eclipse.jdt.junit.core", "org.eclipse.jdt.junit.active_filters", "", null))).filter(Predicate.not(String::isBlank)).map(pattern -> new StringMatcher(pattern, true, false)).collect(Collectors.toList());
    }

    public IAction getOpenTestAction(Shell shell, ITestCaseElement testCase) {
        return new OpenTestAction(shell, testCase, this.getParameterTypes((ITestElement)testCase));
    }

    public IAction getOpenTestAction(Shell shell, ITestSuiteElement testSuite) {
        String testName = testSuite.getTestName();
        List children = testSuite.getChildren();
        if (testName.startsWith("[") && testName.endsWith("]") && !children.isEmpty() && children.get(0) instanceof ITestCaseElement) {
            return new OpenTestAction(shell, (ITestCaseElement)children.get(0), null);
        }
        int index = testName.indexOf(40);
        if (index > 0) {
            return new OpenTestAction(shell, JUnitTestViewSupport.getClassName((ITestElement)testSuite), testName.substring(0, index), this.getParameterTypes((ITestElement)testSuite), true, testSuite.getTestRunSession());
        }
        return new OpenTestAction(shell, testName, testSuite.getTestRunSession());
    }

    public IAction createOpenEditorAction(Shell shell, ITestElement failure, String traceLine) {
        int indexOfFramePrefix;
        String testName;
        block5: {
            testName = traceLine;
            indexOfFramePrefix = testName.indexOf(FRAME_LINE_PREFIX);
            if (indexOfFramePrefix != -1) break block5;
            return null;
        }
        try {
            int innerSeparatorIndex;
            testName = testName.substring(indexOfFramePrefix);
            testName = testName.substring(FRAME_LINE_PREFIX.length(), testName.lastIndexOf(40)).trim();
            int indexOfModuleSeparator = testName.lastIndexOf(47);
            if (indexOfModuleSeparator != -1) {
                testName = testName.substring(indexOfModuleSeparator + 1);
            }
            if ((innerSeparatorIndex = (testName = testName.substring(0, testName.lastIndexOf(46))).indexOf(36)) != -1) {
                testName = testName.substring(0, innerSeparatorIndex);
            }
            String lineNumber = traceLine;
            lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1, lineNumber.lastIndexOf(41));
            int line = Integer.parseInt(lineNumber);
            return new OpenEditorAtLineAction(shell, testName, line, failure.getTestRunSession());
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            JUnitTestPlugin.log(e);
            return null;
        }
    }

    public Runnable createShowStackTraceInConsoleViewActionDelegate(ITestElement failedTest) {
        return new ShowStackTraceInConsoleViewActionDelegate(failedTest);
    }

    public ILaunchConfiguration getRerunLaunchConfiguration(List<ITestElement> tests) {
        ITestKind junitKind;
        if (tests.size() > 1) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)JUnitMessages.JUnitCantRunMultipleTests, (String)JUnitMessages.JUnitCantRunMultipleTests);
            return null;
        }
        ITestElement testSuite = tests.get(0);
        Object testMethodName = null;
        String testName = testSuite.getTestName();
        ILaunchConfiguration launchConfiguration = testSuite.getTestRunSession().getLaunch().getLaunchConfiguration();
        try {
            junitKind = JUnitTestPlugin.JUnitVersion.fromJUnitTestKindId(launchConfiguration.getAttribute("org.eclipse.jdt.junit.TEST_KIND", "")).getJUnitTestKind();
        }
        catch (CoreException e) {
            JUnitTestPlugin.log(e);
            return null;
        }
        IJavaProject project = JUnitLaunchConfigurationConstants.getJavaProject((ILaunchConfiguration)testSuite.getTestRunSession().getLaunch().getLaunchConfiguration());
        if (project == null) {
            return null;
        }
        String qualifiedName = null;
        IType testType = this.findTestClass(testSuite, junitKind.getFinder(), project, true);
        if (testType != null) {
            int index;
            qualifiedName = testType.getFullyQualifiedName();
            if (!qualifiedName.equals(testName) && (index = testName.indexOf(40)) > 0) {
                testMethodName = testName.substring(0, index);
            }
            String[] parameterTypes = this.getParameterTypes(testSuite);
            if (testMethodName != null && parameterTypes != null) {
                String paramTypesStr = Arrays.stream(parameterTypes).collect(Collectors.joining(","));
                testMethodName = (String)testMethodName + "(" + paramTypesStr + ")";
            }
        } else {
            String className;
            testType = this.findTestClass((ITestElement)testSuite.getParent(), junitKind.getFinder(), project, false);
            if (testType != null && testSuite instanceof ITestSuiteElement && !(qualifiedName = testType.getFullyQualifiedName()).equals(className = JUnitTestViewSupport.getClassName(testSuite))) {
                testMethodName = testName;
            }
        }
        try {
            ILaunchConfigurationWorkingCopy res = launchConfiguration.copy(launchConfiguration.getName() + " - rerun");
            res.setAttribute("org.eclipse.jdt.junit.TESTNAME", (String)testMethodName);
            return res;
        }
        catch (CoreException e) {
            JUnitTestPlugin.log(e);
            return null;
        }
    }

    private IType findTestClass(ITestElement element, ITestFinder finder, IJavaProject project, boolean checkOnlyCurrentElement) {
        ITestElement current = element;
        while (current != null) {
            try {
                String className = null;
                if (current instanceof ITestRunSession) {
                    ILaunchConfiguration configuration;
                    ILaunch launch = element.getTestRunSession().getLaunch();
                    if (launch != null && (configuration = launch.getLaunchConfiguration()) != null) {
                        className = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
                    }
                } else {
                    className = JUnitTestViewSupport.getClassName(current);
                }
                if (className != null) {
                    IType type = project.findType(className);
                    if (type != null && finder.isTest(type)) {
                        return type;
                    }
                    if (checkOnlyCurrentElement) {
                        return null;
                    }
                }
            }
            catch (CoreException e) {
                JUnitTestPlugin.log(e);
            }
            current = current.getParent();
        }
        return null;
    }

    public String getDisplayName() {
        return "JUnit";
    }

    public ITestRunnerClient newTestRunnerClient(ITestRunSession session) {
        String portAsString = session.getLaunch().getAttribute("org.eclipse.jdt.ui.unittest.junit.PORT");
        return new JUnitRemoteTestRunnerClient(portAsString != null ? Integer.parseInt(portAsString) : -1, session);
    }

    private String[] getParameterTypes(ITestElement test) {
        int testTemplateIdx;
        String[] result;
        int index;
        String testName = test.getDisplayName();
        if (testName != null && (index = testName.lastIndexOf("method:")) != -1 && (result = this.extractParameters(testName, index)) != null) {
            return result;
        }
        String testUniqData = test.getData();
        if (testUniqData != null && (testTemplateIdx = testUniqData.indexOf("test-template:")) >= 0) {
            return this.extractParameters(testUniqData, testTemplateIdx);
        }
        return null;
    }

    private String[] extractParameters(String testDescription, int startIndex) {
        int closeIndex;
        int index = testDescription.indexOf(40, startIndex);
        if (index > 0 && (closeIndex = testDescription.indexOf(41, index)) > 0) {
            return testDescription.substring(index + 1, closeIndex).split(",");
        }
        return null;
    }

    public static String getClassName(ITestElement test) {
        return JUnitTestViewSupport.extractClassName(test.getTestName());
    }

    private static String extractClassName(String testNameString) {
        testNameString = JUnitTestViewSupport.extractRawClassName(testNameString);
        testNameString = testNameString.replace('$', '.');
        return testNameString;
    }

    public static String extractRawClassName(String testNameString) {
        if (testNameString.startsWith("[") && testNameString.endsWith("]")) {
            return testNameString;
        }
        int index = testNameString.lastIndexOf(40);
        if (index < 0) {
            return testNameString;
        }
        int end = testNameString.lastIndexOf(41);
        return testNameString.substring(index + 1, end > index ? end : testNameString.length());
    }

    public static String getTestMethodName(ITestElement test) {
        String testName = test.getTestName();
        int index = testName.lastIndexOf(40);
        if (index > 0) {
            return testName.substring(0, index);
        }
        index = testName.indexOf(64);
        if (index > 0) {
            return testName.substring(0, index);
        }
        return testName;
    }
}

