/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;

public class JavaAppletLaunchConfigurationDelegate
extends JavaLaunchDelegate
implements IDebugEventSetListener {
    private static Map<ILaunch, File> fgLaunchToFileMap = new HashMap<ILaunch, File>();
    private ILaunch fLaunch;

    @Override
    public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.fLaunch = launch;
            super.launch(configuration, mode, launch, monitor);
        }
        catch (CoreException e) {
            this.cleanup(launch);
            throw e;
        }
        this.fLaunch = null;
    }

    public String getJavaPolicyFile(File workingDir) {
        File file = new File(workingDir, "java.policy.applet");
        if (!file.exists()) {
            File test = LaunchingPlugin.getFileInPlugin((IPath)new Path("java.policy.applet"));
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
                    byte[] bytes = JavaAppletLaunchConfigurationDelegate.getFileByteContent(test);
                    outputStream.write(bytes);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return "";
            }
        }
        return "-Djava.security.policy=java.policy.applet";
    }

    private File buildHTMLFile(ILaunchConfiguration configuration, File dir) throws CoreException {
        String name = this.getAppletMainTypeName(configuration);
        File tempFile = new File(dir, String.valueOf(name) + System.currentTimeMillis() + ".html");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream stream = new FileOutputStream(tempFile);){
                String encoding = this.getLaunchManager().getEncoding(configuration);
                StringBuilder buf = new StringBuilder();
                buf.append("<html>\n");
                buf.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/>\n");
                buf.append("<body>\n");
                buf.append("<applet code=");
                buf.append(name);
                buf.append(".class ");
                String appletName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, "");
                if (appletName.length() != 0) {
                    buf.append("NAME =\"" + appletName + "\" ");
                }
                buf.append("width=\"");
                buf.append(Integer.toString(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200)));
                buf.append("\" height=\"");
                buf.append(Integer.toString(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200)));
                buf.append("\" >\n");
                Map parameters = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, new HashMap());
                if (parameters.size() != 0) {
                    for (Map.Entry next : parameters.entrySet()) {
                        buf.append("<param name=");
                        buf.append(this.getQuotedString((String)next.getKey()));
                        buf.append(" value=");
                        buf.append(this.getQuotedString((String)next.getValue()));
                        buf.append(">\n");
                    }
                }
                buf.append("</applet>\n");
                buf.append("</body>\n");
                buf.append("</html>\n");
                stream.write(buf.toString().getBytes(encoding));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        return tempFile;
    }

    private String getQuotedString(String string) {
        int singleQuotes = JavaAppletLaunchConfigurationDelegate.count(string, '\'');
        int doubleQuotes = JavaAppletLaunchConfigurationDelegate.count(string, '\"');
        if (doubleQuotes == 0) {
            return String.valueOf('\"') + string + '\"';
        }
        if (singleQuotes == 0) {
            return String.valueOf('\'') + string + '\'';
        }
        return String.valueOf('\"') + JavaAppletLaunchConfigurationDelegate.convertToHTMLContent(string) + '\"';
    }

    private static int count(String string, char character) {
        int count = 0;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == character) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static String convertToHTMLContent(String content) {
        content = JavaAppletLaunchConfigurationDelegate.replace(content, '\"', "&quot;");
        content = JavaAppletLaunchConfigurationDelegate.replace(content, '\'', "&#39;");
        return content;
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuilder buffer = new StringBuilder();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    @Override
    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object eventSource = event.getSource();
            switch (event.getKind()) {
                case 8: {
                    if (eventSource == null) break;
                    ILaunch launch = null;
                    if (eventSource instanceof IProcess) {
                        IProcess process = (IProcess)eventSource;
                        launch = process.getLaunch();
                    } else if (eventSource instanceof IDebugTarget) {
                        IDebugTarget debugTarget = (IDebugTarget)eventSource;
                        launch = debugTarget.getLaunch();
                    }
                    if (launch == null) break;
                    this.cleanup(launch);
                }
            }
            ++i;
        }
    }

    private void cleanup(ILaunch launch) {
        File temp = fgLaunchToFileMap.get(launch);
        if (temp != null) {
            try {
                fgLaunchToFileMap.remove(launch);
                temp.delete();
            }
            finally {
                if (fgLaunchToFileMap.isEmpty()) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
        }
    }

    protected static byte[] getFileByteContent(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            return JavaAppletLaunchConfigurationDelegate.getInputStreamAsByteArray(stream, (int)file.length());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int bytesRead = -1;
            do {
                int available;
                if (contentsLength + (available = stream.available()) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + available];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((bytesRead = stream.read(contents, contentsLength, available)) <= 0) continue;
                contentsLength += bytesRead;
            } while (bytesRead > 0);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    @Override
    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(configuration);
        File htmlFile = this.buildHTMLFile(configuration, workingDir);
        if (htmlFile == null) {
            this.abort(LaunchingMessages.JavaAppletLaunchConfigurationDelegate_Could_not_build_HTML_file_for_applet_launch_1, null, 123);
        }
        if (fgLaunchToFileMap.isEmpty()) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        fgLaunchToFileMap.put(this.fLaunch, htmlFile);
        return htmlFile.getName();
    }

    @Override
    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        StringBuilder arguments = new StringBuilder(super.getVMArguments(configuration));
        File workingDir = this.verifyWorkingDirectory(configuration);
        String javaPolicyFile = this.getJavaPolicyFile(workingDir);
        arguments.append(" ");
        arguments.append(javaPolicyFile);
        return arguments.toString();
    }

    @Override
    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "sun.applet.AppletViewer");
    }

    protected String getAppletMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return super.getMainTypeName(configuration);
    }

    @Override
    protected File getDefaultWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String outputDir = JavaRuntime.getProjectOutputDirectory(configuration);
        if (outputDir == null) {
            return new File(System.getProperty("user.dir"));
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(outputDir);
        if (resource == null || !resource.exists()) {
            return new File(System.getProperty("user.dir"));
        }
        return resource.getLocation().toFile();
    }
}

