/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hudson.cli;

import java.io.IOException;
import java.io.OutputStream;

abstract class SequenceOutputStream
extends OutputStream {
    private Block block;

    protected SequenceOutputStream(Block block) {
        this.block = block;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int sz = (int)Math.min((long)len, this.block.capacity);
            this.block.out.write(b, off, sz);
            this.block.capacity -= (long)sz;
            len -= sz;
            off += sz;
            this.swapIfNeeded();
        }
    }

    public void write(int b) throws IOException {
        this.block.out.write(b);
        --this.block.capacity;
        this.swapIfNeeded();
    }

    private void swapIfNeeded() throws IOException {
        if (this.block.capacity > 0L) {
            return;
        }
        this.block.out.close();
        this.block = this.next(this.block);
    }

    public void flush() throws IOException {
        this.block.out.flush();
    }

    public void close() throws IOException {
        this.block.out.close();
        this.block = null;
    }

    protected abstract Block next(Block var1) throws IOException;

    protected static class Block {
        final OutputStream out;
        long capacity;

        public Block(OutputStream out, long capacity) {
            this.out = out;
            this.capacity = capacity;
        }
    }
}

