/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDao;
import org.eclipse.hono.deviceregistry.service.tenant.AbstractTenantService;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.TenantResult;

public final class MongoDbBasedTenantService
extends AbstractTenantService {
    private final TenantDao dao;
    private final MongoDbBasedTenantsConfigProperties config;

    public MongoDbBasedTenantService(TenantDao tenantDao, MongoDbBasedTenantsConfigProperties config) {
        Objects.requireNonNull(tenantDao);
        Objects.requireNonNull(config);
        this.dao = tenantDao;
        this.config = config;
    }

    public Future<TenantResult<JsonObject>> get(String tenantId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(span);
        return this.dao.getByIdOrAlias(tenantId, span.context()).map(tenantDto -> TenantResult.from((int)200, (Object)DeviceRegistryUtils.convertTenant((String)tenantDto.getTenantId(), (Tenant)tenantDto.getData(), (boolean)true), (CacheDirective)DeviceRegistryUtils.getCacheDirective((long)this.config.getCacheMaxAge()))).otherwise(t -> TenantResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t)));
    }

    public Future<TenantResult<JsonObject>> get(X500Principal subjectDn, Span span) {
        Objects.requireNonNull(subjectDn);
        Objects.requireNonNull(span);
        return this.dao.getBySubjectDn(subjectDn, span.context()).map(tenantDto -> TenantResult.from((int)200, (Object)DeviceRegistryUtils.convertTenant((String)tenantDto.getTenantId(), (Tenant)tenantDto.getData(), (boolean)true), (CacheDirective)DeviceRegistryUtils.getCacheDirective((long)this.config.getCacheMaxAge()))).otherwise(t -> TenantResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t)));
    }
}

