/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistrationConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDao;
import org.eclipse.hono.deviceregistry.mongodb.model.DeviceDao;
import org.eclipse.hono.deviceregistry.service.device.AbstractDeviceManagementService;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.management.Filter;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.SearchResult;
import org.eclipse.hono.service.management.Sort;
import org.eclipse.hono.service.management.credentials.CredentialsDto;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceDto;
import org.eclipse.hono.service.management.device.DeviceWithId;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.tracing.TracingHelper;

public final class MongoDbBasedDeviceManagementService
extends AbstractDeviceManagementService {
    private final MongoDbBasedRegistrationConfigProperties config;
    private final DeviceDao deviceDao;
    private final CredentialsDao credentialsDao;

    public MongoDbBasedDeviceManagementService(Vertx vertx, DeviceDao deviceDao, CredentialsDao credentialsDao, MongoDbBasedRegistrationConfigProperties config) {
        super(vertx);
        Objects.requireNonNull(deviceDao);
        Objects.requireNonNull(credentialsDao);
        Objects.requireNonNull(config);
        this.deviceDao = deviceDao;
        this.credentialsDao = credentialsDao;
        this.config = config;
    }

    protected Future<OperationResult<Id>> processCreateDevice(DeviceKey key, Device device, Span span) {
        return this.tenantInformationService.getTenant(key.getTenantId(), span).compose(tenant -> this.checkDeviceLimitReached((Tenant)tenant, key.getTenantId(), span)).compose(ok -> {
            DeviceDto deviceDto = DeviceDto.forCreation(DeviceDto::new, (String)key.getTenantId(), (String)key.getDeviceId(), (Device)device, (String)DeviceRegistryUtils.getUniqueIdentifier());
            return this.deviceDao.create(deviceDto, span.context());
        }).compose(deviceResourceVersion -> {
            CredentialsDto emptySetOfCredentials = CredentialsDto.forCreation((String)key.getTenantId(), (String)key.getDeviceId(), List.of(), (String)DeviceRegistryUtils.getUniqueIdentifier());
            return this.credentialsDao.create(emptySetOfCredentials, span.context()).map(deviceResourceVersion).recover(t -> {
                TracingHelper.logError((Span)span, (String)"failed to create device with empty set of credentials, rolling back ...", (Throwable)t);
                return this.deviceDao.delete(key.getTenantId(), key.getDeviceId(), Optional.empty(), span.context()).compose(done -> Future.failedFuture((Throwable)t)).recover(error -> Future.failedFuture((Throwable)t));
            });
        }).map(deviceResourceVersion -> OperationResult.ok((int)201, (Object)Id.of((String)key.getDeviceId()), Optional.empty(), Optional.of(deviceResourceVersion)));
    }

    protected Future<OperationResult<Device>> processReadDevice(DeviceKey key, Span span) {
        return this.deviceDao.getById(key.getTenantId(), key.getDeviceId(), span.context()).map(deviceDto -> OperationResult.ok((int)200, (Object)deviceDto.getDeviceWithStatus(), Optional.ofNullable(DeviceRegistryUtils.getCacheDirective((long)this.config.getCacheMaxAge())), Optional.ofNullable(deviceDto.getVersion())));
    }

    protected Future<OperationResult<SearchResult<DeviceWithId>>> processSearchDevices(String tenantId, int pageSize, int pageOffset, List<Filter> filters, List<Sort> sortOptions, Optional<Boolean> isGateway, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(filters);
        Objects.requireNonNull(sortOptions);
        Objects.requireNonNull(isGateway);
        Objects.requireNonNull(span);
        return this.tenantInformationService.getTenant(tenantId, span).compose(ok -> this.deviceDao.find(tenantId, pageSize, pageOffset, filters, sortOptions, isGateway, span.context())).map(result -> OperationResult.ok((int)200, (Object)result, Optional.empty(), Optional.empty()));
    }

    protected Future<OperationResult<Id>> processUpdateDevice(DeviceKey key, Device device, Optional<String> resourceVersion, Span span) {
        return this.deviceDao.getById(key.getTenantId(), key.getDeviceId(), span.context()).map(currentDeviceConfig -> DeviceDto.forUpdate(() -> currentDeviceConfig, (String)key.getTenantId(), (String)key.getDeviceId(), (Device)device, (String)DeviceRegistryUtils.getUniqueIdentifier())).compose(updatedDeviceConfig -> this.deviceDao.update((DeviceDto)updatedDeviceConfig, resourceVersion, span.context())).map(newResourceVersion -> OperationResult.ok((int)204, (Object)Id.of((String)key.getDeviceId()), Optional.empty(), Optional.of(newResourceVersion)));
    }

    protected Future<Result<Void>> processDeleteDevice(DeviceKey key, Optional<String> resourceVersion, Span span) {
        return this.deviceDao.delete(key.getTenantId(), key.getDeviceId(), resourceVersion, span.context()).compose(ok -> this.credentialsDao.delete(key.getTenantId(), key.getDeviceId(), Optional.empty(), span.context()).recover(t -> Future.succeededFuture())).map(ok -> Result.from((int)204));
    }

    protected Future<Result<Void>> processDeleteDevicesOfTenant(String tenantId, Span span) {
        return this.deviceDao.delete(tenantId, span.context()).compose(ok -> this.credentialsDao.delete(tenantId, span.context()).recover(t -> Future.succeededFuture())).map(ok -> Result.from((int)204));
    }

    private Future<Void> checkDeviceLimitReached(Tenant tenant, String tenantId, Span span) {
        return this.deviceDao.count(tenantId, span.context()).compose(currentDeviceCount -> tenant.checkDeviceLimitReached(tenantId, currentDeviceCount.longValue(), this.config.getMaxDevicesPerTenant()));
    }
}

