/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.management.Filter;
import org.eclipse.hono.service.management.Sort;

public final class MongoDbDocumentBuilder {
    public static final String DEVICE_VIA_PATH = String.format("%s.%s", "device", "via");
    public static final String DEVICE_MEMBEROF_PATH = String.format("%s.%s", "device", "memberOf");
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private static final JsonPointer FIELD_ID = JsonPointer.from((String)"/id");
    private static final String TENANT_ALIAS_PATH = String.format("%s.%s", "tenant", "alias");
    private static final String TENANT_TRUST_ANCHOR_GROUP_PATH = String.format("%s.%s", "tenant", "trust-anchor-group");
    private static final String TENANT_TRUSTED_CA_PATH = String.format("%s.%s", "tenant", "trusted-ca");
    private static final String TENANT_TRUSTED_CA_SUBJECT_PATH = String.format("%s.%s", TENANT_TRUSTED_CA_PATH, "subject-dn");
    private static final String MONGODB_OPERATOR_AND = "$and";
    private static final String MONGODB_OPERATOR_ELEM_MATCH = "$elemMatch";
    private static final String MONGODB_OPERATOR_EXISTS = "$exists";
    private static final String MONGODB_OPERATOR_IN = "$in";
    private static final String MONGODB_OPERATOR_NOT = "$not";
    private static final String MONGODB_OPERATOR_NOT_EQUALS = "$ne";
    private static final String MONGODB_OPERATOR_OR = "$or";
    private static final String MONGODB_OPERATOR_REGEX = "$regex";
    private final JsonObject document = new JsonObject();

    private MongoDbDocumentBuilder() {
    }

    public static MongoDbDocumentBuilder builder() {
        return new MongoDbDocumentBuilder();
    }

    public JsonObject document() {
        return this.document;
    }

    public MongoDbDocumentBuilder withTenantId(String tenantId) {
        this.document.put("tenant-id", (Object)tenantId);
        return this;
    }

    public MongoDbDocumentBuilder withGatewayDevices() {
        this.document.put(DEVICE_VIA_PATH, (Object)new JsonObject().put(MONGODB_OPERATOR_EXISTS, (Object)true));
        return this;
    }

    public MongoDbDocumentBuilder withMemberOfAnyGatewayGroup() {
        this.document.put(DEVICE_MEMBEROF_PATH, (Object)new JsonObject().put(MONGODB_OPERATOR_EXISTS, (Object)true).put(MONGODB_OPERATOR_NOT_EQUALS, (Object)EMPTY_ARRAY));
        return this;
    }

    public MongoDbDocumentBuilder withTenantIdOrAlias(String tenantId) {
        this.document.put(MONGODB_OPERATOR_OR, (Object)new JsonArray().add((Object)new JsonObject().put("tenant-id", (Object)tenantId)).add((Object)new JsonObject().put(MONGODB_OPERATOR_AND, (Object)new JsonArray().add((Object)new JsonObject().put(TENANT_ALIAS_PATH, (Object)new JsonObject().put(MONGODB_OPERATOR_EXISTS, (Object)true))).add((Object)new JsonObject().put(TENANT_ALIAS_PATH, (Object)tenantId)))));
        return this;
    }

    public MongoDbDocumentBuilder withOtherTenantId(String tenantId) {
        this.document.put("tenant-id", (Object)new JsonObject().put(MONGODB_OPERATOR_NOT_EQUALS, (Object)tenantId));
        return this;
    }

    public MongoDbDocumentBuilder withDeviceId(String deviceId) {
        this.document.put("device-id", (Object)deviceId);
        return this;
    }

    public MongoDbDocumentBuilder withCa(String subjectDn) {
        this.document.put(TENANT_TRUSTED_CA_SUBJECT_PATH, (Object)new JsonObject().put("$eq", (Object)subjectDn));
        return this;
    }

    public MongoDbDocumentBuilder withAnyCa(List<String> subjectDns) {
        this.document.put(TENANT_TRUSTED_CA_PATH, (Object)new JsonObject().put(MONGODB_OPERATOR_ELEM_MATCH, (Object)new JsonObject().put("subject-dn", (Object)new JsonObject().put(MONGODB_OPERATOR_IN, (Object)new JsonArray(subjectDns)))));
        return this;
    }

    public MongoDbDocumentBuilder withVersion(Optional<String> version) {
        Objects.requireNonNull(version);
        version.ifPresent(ver -> this.document.put("version", ver));
        return this;
    }

    public MongoDbDocumentBuilder withType(String type) {
        return this.withCredentialsPredicate("type", type);
    }

    public MongoDbDocumentBuilder withAuthId(String authId) {
        return this.withCredentialsPredicate("auth-id", authId);
    }

    public MongoDbDocumentBuilder withTrustAnchorGroup(String trustAnchorGroup) {
        this.document.put(MONGODB_OPERATOR_OR, (Object)new JsonArray().add((Object)new JsonObject().put(TENANT_TRUST_ANCHOR_GROUP_PATH, (Object)new JsonObject().put(MONGODB_OPERATOR_EXISTS, (Object)false))).add((Object)new JsonObject().put(TENANT_TRUST_ANCHOR_GROUP_PATH, (Object)new JsonObject().put(MONGODB_OPERATOR_NOT_EQUALS, (Object)trustAnchorGroup))));
        return this;
    }

    public MongoDbDocumentBuilder withDeviceFilters(List<Filter> filters) {
        Objects.requireNonNull(filters);
        this.applySearchFilters(filters, MongoDbDocumentBuilder::mapDeviceField);
        return this;
    }

    public MongoDbDocumentBuilder withTenantFilters(List<Filter> filters) {
        Objects.requireNonNull(filters);
        this.applySearchFilters(filters, MongoDbDocumentBuilder::mapTenantField);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceSortOptions(List<Sort> sortOptions) {
        Objects.requireNonNull(sortOptions);
        this.applySortingOptions(sortOptions, MongoDbDocumentBuilder::mapDeviceField);
        return this;
    }

    public MongoDbDocumentBuilder withTenantSortOptions(List<Sort> sortOptions) {
        Objects.requireNonNull(sortOptions);
        this.applySortingOptions(sortOptions, MongoDbDocumentBuilder::mapTenantField);
        return this;
    }

    private void applyEqFilter(Filter filter, Function<JsonPointer, String> fieldMapper) {
        Object object = filter.getValue();
        if (object instanceof String) {
            String stringValue = (String)object;
            this.document.put(fieldMapper.apply(filter.getField()), (Object)new JsonObject().put(MONGODB_OPERATOR_REGEX, (Object)DeviceRegistryUtils.getRegexExpressionForSearchOperation((String)stringValue)));
        } else {
            this.document.put(fieldMapper.apply(filter.getField()), filter.getValue());
        }
    }

    private void applyInFilter(Filter filter, Function<JsonPointer, String> fieldMapper) {
        Object object = filter.getValue();
        if (object instanceof JsonArray) {
            JsonArray valueList = (JsonArray)object;
            JsonObject expr = new JsonObject().put(MONGODB_OPERATOR_IN, (Object)valueList);
            switch (filter.getOperator()) {
                case in: {
                    this.document.put(fieldMapper.apply(filter.getField()), (Object)expr);
                    break;
                }
                case not_in: {
                    this.document.put(fieldMapper.apply(filter.getField()), (Object)new JsonObject().put(MONGODB_OPERATOR_NOT, (Object)expr));
                    break;
                }
            }
        }
    }

    private void applySearchFilters(List<Filter> filters, Function<JsonPointer, String> fieldMapper) {
        filters.forEach(filter -> {
            switch (filter.getOperator()) {
                case eq: {
                    this.applyEqFilter((Filter)filter, fieldMapper);
                    break;
                }
                case in: 
                case not_in: {
                    this.applyInFilter((Filter)filter, fieldMapper);
                }
            }
        });
    }

    private void applySortingOptions(List<Sort> sortOptions, Function<JsonPointer, String> fieldMapper) {
        if (sortOptions.isEmpty()) {
            this.document.put(fieldMapper.apply(FIELD_ID), (Object)MongoDbDocumentBuilder.mapSortingDirection(Sort.Direction.ASC));
        } else {
            sortOptions.forEach(sortOption -> this.document.put((String)fieldMapper.apply(sortOption.getField()), (Object)MongoDbDocumentBuilder.mapSortingDirection(sortOption.getDirection())));
        }
    }

    private MongoDbDocumentBuilder withCredentialsPredicate(String field, String value) {
        JsonObject credentialsArraySpec = this.document.getJsonObject("credentials", new JsonObject());
        JsonObject elementMatchSpec = credentialsArraySpec.getJsonObject(MONGODB_OPERATOR_ELEM_MATCH, new JsonObject());
        elementMatchSpec.put(field, (Object)value);
        credentialsArraySpec.put(MONGODB_OPERATOR_ELEM_MATCH, (Object)elementMatchSpec);
        this.document.put("credentials", (Object)credentialsArraySpec);
        return this;
    }

    private static String mapDeviceField(JsonPointer field) {
        if (FIELD_ID.equals(field)) {
            return "device-id";
        }
        return "device" + field.toString().replace("/", ".");
    }

    private static String mapTenantField(JsonPointer field) {
        if (FIELD_ID.equals(field)) {
            return "tenant-id";
        }
        return "tenant" + field.toString().replace("/", ".");
    }

    private static int mapSortingDirection(Sort.Direction direction) {
        if (direction == Sort.Direction.ASC) {
            return 1;
        }
        return -1;
    }
}

