/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.app;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.eclipse.hono.deviceregistry.app.AbstractAmqpServerFactory;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDao;
import org.eclipse.hono.deviceregistry.mongodb.model.DeviceDao;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDao;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedCredentialsService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedRegistrationService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedTenantService;
import org.eclipse.hono.deviceregistry.service.credentials.AbstractCredentialsService;
import org.eclipse.hono.deviceregistry.service.device.AbstractRegistrationService;
import org.eclipse.hono.service.tenant.TenantService;

@ApplicationScoped
public class AmqpServerFactory
extends AbstractAmqpServerFactory {
    @Inject
    TenantDao tenantDao;
    @Inject
    MongoDbBasedTenantsConfigProperties tenantServiceConfiguration;
    @Inject
    DeviceDao deviceDao;
    @Inject
    CredentialsDao credentialsDao;
    @Inject
    MongoDbBasedCredentialsConfigProperties credentialsServiceProperties;

    protected TenantService createTenantService() {
        return new MongoDbBasedTenantService(this.tenantDao, this.tenantServiceConfiguration);
    }

    protected AbstractRegistrationService createRegistrationService() {
        return new MongoDbBasedRegistrationService(this.deviceDao);
    }

    protected AbstractCredentialsService createCredentialsService() {
        return new MongoDbBasedCredentialsService(this.credentialsDao, this.credentialsServiceProperties);
    }
}

