/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDao;
import org.eclipse.hono.deviceregistry.service.tenant.TenantInformationService;
import org.eclipse.hono.deviceregistry.service.tenant.TenantKey;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.service.management.tenant.TenantDto;

public final class DaoBasedTenantInformationService
implements TenantInformationService {
    private final TenantDao dao;

    public DaoBasedTenantInformationService(TenantDao tenantDao) {
        this.dao = Objects.requireNonNull(tenantDao);
    }

    public Future<Tenant> getTenant(String tenantId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(span);
        return this.dao.getById(tenantId, span.context()).map(TenantDto::getData);
    }

    public Future<Result<TenantKey>> tenantExists(String tenantId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(span);
        return this.dao.getById(tenantId, span.context()).map(dto -> OperationResult.ok((int)200, (Object)TenantKey.from((String)tenantId), Optional.empty(), Optional.empty()));
    }
}

