/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hono.deviceregistry.mongodb.config.AbstractMongoDbBasedRegistryConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigOptions;

public final class MongoDbBasedCredentialsConfigProperties
extends AbstractMongoDbBasedRegistryConfigProperties {
    private static final String DEFAULT_CREDENTIALS_COLLECTION_NAME = "credentials";
    private final Set<String> hashAlgorithmsWhitelist = new HashSet<String>();
    private int maxBcryptCostFactor = 10;

    public MongoDbBasedCredentialsConfigProperties() {
    }

    public MongoDbBasedCredentialsConfigProperties(MongoDbBasedCredentialsConfigOptions options) {
        super(options.commonOptions());
        this.setCollectionName(options.collectionName());
        options.encryptionKeyFile().ifPresent(this::setEncryptionKeyFile);
        options.hashAlgorithmsWhitelist().ifPresent(algorithms -> this.setHashAlgorithmsWhitelist((String[])algorithms.toArray(String[]::new)));
        this.setMaxBcryptCostFactor(options.maxBcryptCostFactor());
    }

    @Override
    protected String getDefaultCollectionName() {
        return DEFAULT_CREDENTIALS_COLLECTION_NAME;
    }

    public int getMaxBcryptCostFactor() {
        return this.maxBcryptCostFactor;
    }

    public void setMaxBcryptCostFactor(int costFactor) {
        if (costFactor < 4 || costFactor > 31) {
            throw new IllegalArgumentException("iterations must be > 3 and < 32");
        }
        this.maxBcryptCostFactor = costFactor;
    }

    public Set<String> getHashAlgorithmsWhitelist() {
        return Collections.unmodifiableSet(this.hashAlgorithmsWhitelist);
    }

    public void setHashAlgorithmsWhitelist(String[] hashAlgorithmsWhitelist) {
        Objects.requireNonNull(hashAlgorithmsWhitelist);
        this.hashAlgorithmsWhitelist.clear();
        this.hashAlgorithmsWhitelist.addAll(Arrays.asList(hashAlgorithmsWhitelist));
    }
}

