/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.config;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbConfigOptions;
import org.eclipse.hono.util.PortConfigurationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbConfigProperties {
    public static final int DEFAULT_PORT = 27017;
    public static final int DEFAULT_SERVER_SELECTION_TIMEOUT_IN_MS = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbConfigProperties.class);
    private String host = "localhost";
    private int port = 27017;
    private String dbName;
    private String username;
    private String password;
    private String connectionString;
    private Integer serverSelectionTimeoutInMs = 1000;
    private Integer connectionTimeoutInMs;

    public MongoDbConfigProperties() {
    }

    public MongoDbConfigProperties(MongoDbConfigOptions options) {
        Objects.requireNonNull(options);
        options.host().ifPresent(this::setHost);
        this.setPort(options.port());
        options.dbName().ifPresent(this::setDbName);
        options.username().ifPresent(this::setUsername);
        options.password().ifPresent(this::setPassword);
        options.connectionString().ifPresent(this::setConnectionString);
        this.setConnectTimeout(options.connectTimeout());
        this.setServerSelectionTimeout(options.serverSelectionTimeout());
    }

    public String getHost() {
        return this.host;
    }

    public MongoDbConfigProperties setHost(String host) {
        this.host = Objects.requireNonNull(host);
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MongoDbConfigProperties setPort(int port) {
        if (!PortConfigurationHelper.isValidPort((int)port)) {
            throw new IllegalArgumentException("invalid port number");
        }
        this.port = port;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public MongoDbConfigProperties setDbName(String dbName) {
        this.dbName = Objects.requireNonNull(dbName);
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public MongoDbConfigProperties setUsername(String username) {
        this.username = Objects.requireNonNull(username);
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public MongoDbConfigProperties setPassword(String password) {
        this.password = Objects.requireNonNull(password);
        return this;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public MongoDbConfigProperties setConnectionString(String connectionString) {
        this.connectionString = Objects.requireNonNull(connectionString);
        return this;
    }

    public Integer getServerSelectionTimeout() {
        return this.serverSelectionTimeoutInMs;
    }

    public MongoDbConfigProperties setServerSelectionTimeout(int serverSelectionTimeoutInMs) {
        if (serverSelectionTimeoutInMs < 0) {
            throw new IllegalArgumentException("server selection timeout must not be negative");
        }
        this.serverSelectionTimeoutInMs = serverSelectionTimeoutInMs;
        return this;
    }

    public Integer getConnectTimeout() {
        return this.connectionTimeoutInMs;
    }

    public MongoDbConfigProperties setConnectTimeout(int connectionTimeoutInMs) {
        if (connectionTimeoutInMs < 0) {
            throw new IllegalArgumentException("connection timeout must not be negative");
        }
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        return this;
    }

    public JsonObject getMongoClientConfig() {
        JsonObject configJson = new JsonObject();
        if (this.connectionString != null) {
            configJson.put("connection_string", (Object)this.connectionString);
            LOG.info("using connection string, ignoring other connection properties");
        } else {
            configJson.put("host", (Object)this.host).put("port", (Object)this.port).put("db_name", (Object)this.dbName).put("username", (Object)this.username).put("password", (Object)this.password);
            Optional.ofNullable(this.getServerSelectionTimeout()).ifPresent(timeout -> configJson.put("serverSelectionTimeoutMS", timeout));
            Optional.ofNullable(this.getConnectTimeout()).ifPresent(timeout -> configJson.put("connectTimeoutMS", timeout));
        }
        return configJson;
    }
}

