/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.config;

import io.vertx.ext.auth.mongo.HashAlgorithm;
import io.vertx.ext.auth.mongo.HashSaltStyle;
import java.util.Objects;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoAuthProviderOptions;

public final class MongoAuthProviderConfig {
    private String collectionName = "user";
    private HashSaltStyle saltStyle = HashSaltStyle.COLUMN;
    private String saltField = "salt";
    private String usernameField = "username";
    private String passwordField = "password";
    private HashAlgorithm hashAlgorithm = HashAlgorithm.PBKDF2;

    public MongoAuthProviderConfig() {
    }

    public MongoAuthProviderConfig(MongoAuthProviderOptions options) {
        Objects.requireNonNull(options);
        this.setCollectionName(options.collectionName());
        this.setHashAlgorithm(options.hashAlgorithm());
        this.setPasswordField(options.passwordField());
        this.setSaltField(options.saltField());
        this.setSaltStyle(options.saltStyle());
        this.setUsernameField(options.usernameField());
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = Objects.requireNonNull(collectionName);
    }

    public HashSaltStyle getSaltStyle() {
        return this.saltStyle;
    }

    public void setSaltStyle(HashSaltStyle strategy) {
        this.saltStyle = Objects.requireNonNull(strategy);
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(HashAlgorithm algorithm) {
        this.hashAlgorithm = Objects.requireNonNull(algorithm);
    }

    public String getSaltField() {
        return this.saltField;
    }

    public void setSaltField(String name) {
        this.saltField = Objects.requireNonNull(name);
    }

    public String getUsernameField() {
        return this.usernameField;
    }

    public void setUsernameField(String name) {
        this.usernameField = Objects.requireNonNull(name);
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String name) {
        this.passwordField = Objects.requireNonNull(name);
    }

    public String toString() {
        return "MongoAuthProviderConfig [collectionName=" + this.collectionName + ", saltStyle=" + this.saltStyle + ", saltField=" + this.saltField + ", usernameField=" + this.usernameField + ", passwordField=" + this.passwordField + ", hashAlgorithm=" + this.hashAlgorithm + "]";
    }
}

