/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.config;

import java.util.Objects;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistryConfigOptions;

public abstract class AbstractMongoDbBasedRegistryConfigProperties {
    public static final int DEFAULT_MAX_AGE_SECONDS = 180;
    private int cacheMaxAge = 180;
    private String collectionName = this.getDefaultCollectionName();
    private String encryptionKeyFile;

    protected AbstractMongoDbBasedRegistryConfigProperties() {
    }

    protected AbstractMongoDbBasedRegistryConfigProperties(MongoDbBasedRegistryConfigOptions options) {
        Objects.requireNonNull(options);
        this.setCacheMaxAge(options.cacheMaxAge());
    }

    protected abstract String getDefaultCollectionName();

    public final String getCollectionName() {
        return this.collectionName;
    }

    public final void setCollectionName(String collectionName) {
        this.collectionName = Objects.requireNonNull(collectionName);
    }

    public final int getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public final void setCacheMaxAge(int maxAge) {
        if (maxAge < 0) {
            throw new IllegalArgumentException("max age must be >= 0");
        }
        this.cacheMaxAge = maxAge;
    }

    public final void setEncryptionKeyFile(String path) {
        this.encryptionKeyFile = Objects.requireNonNull(path);
    }

    public final String getEncryptionKeyFile() {
        return this.encryptionKeyFile;
    }
}

