/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.app;

import com.bol.config.CryptVaultAutoConfiguration;
import com.bol.crypt.CryptVault;
import io.opentracing.Tracer;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigOptions;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistrationConfigOptions;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigOptions;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbConfigOptions;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDao;
import org.eclipse.hono.deviceregistry.mongodb.model.DeviceDao;
import org.eclipse.hono.deviceregistry.mongodb.model.MongoDbBasedCredentialsDao;
import org.eclipse.hono.deviceregistry.mongodb.model.MongoDbBasedDeviceDao;
import org.eclipse.hono.deviceregistry.mongodb.model.MongoDbBasedTenantDao;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDao;
import org.eclipse.hono.deviceregistry.util.CryptVaultBasedFieldLevelEncryption;
import org.eclipse.hono.deviceregistry.util.FieldLevelEncryption;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.HealthCheckServer;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@ApplicationScoped
public class DaoProducer {
    @Inject
    Vertx vertx;
    @Inject
    Tracer tracer;
    @Inject
    HealthCheckServer healthCheckServer;

    @Produces
    @Singleton
    public MongoClient mongoClient(MongoDbConfigOptions options) {
        return MongoClient.createShared((Vertx)this.vertx, (JsonObject)new MongoDbConfigProperties(options).getMongoClientConfig());
    }

    @Produces
    @Singleton
    public TenantDao tenantDao(MongoClient mongoClient, MongoDbBasedTenantsConfigOptions config) {
        MongoDbBasedTenantDao dao = new MongoDbBasedTenantDao(this.vertx, mongoClient, config.collectionName(), this.tracer);
        this.healthCheckServer.registerHealthCheckResources((HealthCheckProvider)dao);
        return dao;
    }

    @Produces
    @Singleton
    public DeviceDao deviceDao(MongoClient mongoClient, MongoDbBasedRegistrationConfigOptions options) {
        MongoDbBasedDeviceDao dao = new MongoDbBasedDeviceDao(this.vertx, mongoClient, options.collectionName(), this.tracer);
        this.healthCheckServer.registerHealthCheckResources((HealthCheckProvider)dao);
        return dao;
    }

    @Produces
    @Singleton
    public CredentialsDao credentialsDao(MongoClient mongoClient, MongoDbBasedCredentialsConfigOptions options) {
        FieldLevelEncryption encryptionHelper = options.encryptionKeyFile().map(this::fieldLevelEncryption).orElse(FieldLevelEncryption.NOOP_ENCRYPTION);
        MongoDbBasedCredentialsDao dao = new MongoDbBasedCredentialsDao(this.vertx, mongoClient, options.collectionName(), this.tracer, encryptionHelper);
        this.healthCheckServer.registerHealthCheckResources((HealthCheckProvider)dao);
        return dao;
    }

    private FieldLevelEncryption fieldLevelEncryption(String path) {
        CryptVaultBasedFieldLevelEncryption cryptVaultBasedFieldLevelEncryption;
        FileInputStream in = new FileInputStream(path);
        try {
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(CryptVaultAutoConfiguration.CryptVaultConfigurationProperties.class));
            CryptVaultAutoConfiguration.CryptVaultConfigurationProperties config = (CryptVaultAutoConfiguration.CryptVaultConfigurationProperties)yaml.load((InputStream)in);
            CryptVault cryptVault = new CryptVault();
            for (CryptVaultAutoConfiguration.Key key : config.getKeys()) {
                byte[] secretKeyBytes = Base64.getDecoder().decode(key.getKey());
                cryptVault.with256BitAesCbcPkcs5PaddingAnd128BitSaltKey(key.getVersion(), secretKeyBytes);
            }
            Optional.ofNullable(config.getDefaultKey()).ifPresent(arg_0 -> ((CryptVault)cryptVault).withDefaultKeyVersion(arg_0));
            cryptVaultBasedFieldLevelEncryption = new CryptVaultBasedFieldLevelEncryption(cryptVault);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("error reading CryptVault configuration from file [%s]", path), e);
            }
        }
        in.close();
        return cryptVaultBasedFieldLevelEncryption;
    }
}

