/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.app;

import io.vertx.core.Vertx;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistrationConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDao;
import org.eclipse.hono.deviceregistry.mongodb.model.DeviceDao;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDao;
import org.eclipse.hono.deviceregistry.mongodb.service.DaoBasedTenantInformationService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedCredentialsManagementService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedDeviceManagementService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedTenantManagementService;
import org.eclipse.hono.deviceregistry.service.tenant.TenantInformationService;
import org.eclipse.hono.service.auth.HonoPasswordEncoder;
import org.eclipse.hono.service.auth.SpringBasedHonoPasswordEncoder;
import org.eclipse.hono.service.management.credentials.CredentialsManagementService;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.service.management.tenant.TenantManagementService;

@ApplicationScoped
public class ManagementServicesProducer {
    @Inject
    Vertx vertx;
    @Inject
    MongoDbBasedTenantsConfigProperties tenantServiceProperties;
    @Inject
    MongoDbBasedRegistrationConfigProperties registrationServiceProperties;
    @Inject
    MongoDbBasedCredentialsConfigProperties credentialsServiceProperties;

    @Produces
    @Singleton
    public TenantInformationService tenantInformationService(TenantDao tenantDao) {
        return new DaoBasedTenantInformationService(tenantDao);
    }

    @Produces
    @Singleton
    public TenantManagementService tenantManagementService(TenantDao tenantDao) {
        return new MongoDbBasedTenantManagementService(this.vertx, tenantDao, this.tenantServiceProperties);
    }

    @Produces
    @Singleton
    public DeviceManagementService deviceManagementService(DeviceDao deviceDao, CredentialsDao credentialsDao, TenantInformationService tenantInformationService) {
        MongoDbBasedDeviceManagementService service = new MongoDbBasedDeviceManagementService(this.vertx, deviceDao, credentialsDao, this.registrationServiceProperties);
        service.setTenantInformationService(tenantInformationService);
        return service;
    }

    @Produces
    @Singleton
    public CredentialsManagementService credentialsManagementService(CredentialsDao credentialsDao, TenantInformationService tenantInformationService) {
        MongoDbBasedCredentialsManagementService service = new MongoDbBasedCredentialsManagementService(this.vertx, credentialsDao, this.credentialsServiceProperties, (HonoPasswordEncoder)new SpringBasedHonoPasswordEncoder(this.credentialsServiceProperties.getMaxBcryptCostFactor()));
        service.setTenantInformationService(tenantInformationService);
        return service;
    }
}

