/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.model;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.UpdateOptions;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDao;
import org.eclipse.hono.deviceregistry.mongodb.model.MongoDbBasedDao;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDocumentBuilder;
import org.eclipse.hono.deviceregistry.util.FieldLevelEncryption;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.management.credentials.CredentialsDto;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedCredentialsDao
extends MongoDbBasedDao
implements CredentialsDao,
HealthCheckProvider {
    public static final String IDX_CREDENTIALS_TYPE_AND_AUTH_ID = "credentials_type_and_auth_id";
    public static final JsonObject PROJECTION_CREDS_BY_TYPE_AND_AUTH_ID = new JsonObject().put("device-id", (Object)1).put(String.format("%s.$", "credentials"), (Object)1).put("_id", (Object)0);
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedCredentialsDao.class);
    private static final String KEY_AUTH_ID = String.format("%s.%s", "credentials", "auth-id");
    private static final String KEY_CREDENTIALS_TYPE = String.format("%s.%s", "credentials", "type");
    private final AtomicBoolean creatingIndices = new AtomicBoolean(false);
    private final AtomicBoolean indicesCreated = new AtomicBoolean(false);

    public MongoDbBasedCredentialsDao(MongoClient mongoClient, String collectionName, Tracer tracer, FieldLevelEncryption fieldLevelEncryption) {
        super(mongoClient, collectionName, tracer, fieldLevelEncryption);
        Optional.ofNullable(fieldLevelEncryption).ifPresent(helper -> LOG.info("using [{}] for encrypting credentials", (Object)helper.getClass().getName()));
    }

    public Future<Void> createIndices() {
        Promise result = Promise.promise();
        if (this.creatingIndices.compareAndSet(false, true)) {
            this.createIndex(new JsonObject().put("tenant-id", (Object)1).put("device-id", (Object)1), new IndexOptions().unique(true)).compose(ok -> this.createIndex(new JsonObject().put("tenant-id", (Object)1).put(KEY_AUTH_ID, (Object)1).put(KEY_CREDENTIALS_TYPE, (Object)1), new IndexOptions().unique(true).partialFilterExpression(new JsonObject().put(KEY_AUTH_ID, (Object)new JsonObject().put("$exists", (Object)true)).put(KEY_CREDENTIALS_TYPE, (Object)new JsonObject().put("$exists", (Object)true))))).compose(ok -> this.createIndex(new JsonObject().put(KEY_AUTH_ID, (Object)1).put(KEY_CREDENTIALS_TYPE, (Object)1), new IndexOptions().name(IDX_CREDENTIALS_TYPE_AND_AUTH_ID))).onSuccess(ok -> this.indicesCreated.set(true)).onComplete(r -> {
                this.creatingIndices.set(false);
                result.handle(r);
            });
        } else {
            LOG.debug("already trying to create indices");
        }
        return result.future();
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register("credentials-indices-created-" + UUID.randomUUID(), status -> {
            if (this.indicesCreated.get()) {
                status.tryComplete((Object)Status.OK());
            } else {
                LOG.debug("credentials-indices not (yet) created");
                status.tryComplete((Object)Status.KO());
                this.createIndices();
            }
        });
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    @Override
    public Future<String> create(CredentialsDto credentials, SpanContext tracingContext) {
        Objects.requireNonNull(credentials);
        Span span = this.tracer.buildSpan("add Credentials").addReference("child_of", tracingContext).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)credentials.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)credentials.getDeviceId()).start();
        credentials.getCredentials().stream().forEach(cred -> cred.encryptFields(this.fieldLevelEncryption));
        JsonObject document = JsonObject.mapFrom((Object)credentials);
        if (LOG.isTraceEnabled()) {
            LOG.trace("creating credentials for device [tenant: {}, device-id: {}, resource-version; {}]:{}{}", new Object[]{credentials.getTenantId(), credentials.getDeviceId(), credentials.getVersion(), System.lineSeparator(), document.encodePrettily()});
        }
        return this.mongoClient.insert(this.collectionName, document).map(added -> {
            span.log("successfully added credentials");
            LOG.debug("successfully added credentials for device [tenant: {}, device-id: {}, resource-version: {}]", new Object[]{credentials.getTenantId(), credentials.getDeviceId(), credentials.getVersion()});
            return credentials.getVersion();
        }).onFailure(t -> {
            LOG.debug("error adding credentials for device [tenant: {}, device-id: {}]", new Object[]{credentials.getTenantId(), credentials.getDeviceId(), t});
            TracingHelper.logError((Span)span, (String)"error adding credentials", (Throwable)t);
        }).recover(this::mapError).onComplete(r -> span.finish());
    }

    @Override
    public Future<CredentialsDto> getByDeviceId(String tenantId, String deviceId, SpanContext tracingContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Span span = this.tracer.buildSpan("get Credentials by device ID").addReference("child_of", tracingContext).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)deviceId).start();
        return this.getByDeviceId(tenantId, deviceId).onFailure(t -> {
            LOG.debug("error retrieving credentials by device ID", t);
            TracingHelper.logError((Span)span, (String)"error retrieving credentials by device ID", (Throwable)t);
        }).recover(this::mapError).onComplete(r -> span.finish());
    }

    private Future<CredentialsDto> getByDeviceId(String tenantId, String deviceId) {
        LOG.trace("retrieving credentials for device [tenant-id: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
        JsonObject findCredentialsQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withDeviceId(deviceId).document();
        return this.mongoClient.findOne(this.collectionName, findCredentialsQuery, null).map(result -> {
            if (result == null) {
                throw new ClientErrorException(tenantId, 404, "no matching credentials on record");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("credentials data from collection:{}{}", (Object)System.lineSeparator(), (Object)result.encodePrettily());
            }
            CredentialsDto dto = (CredentialsDto)result.mapTo(CredentialsDto.class);
            dto.getCredentials().stream().forEach(cred -> cred.decryptFields(this.fieldLevelEncryption));
            return dto;
        });
    }

    @Override
    public Future<CredentialsDto> getByAuthIdAndType(String tenantId, String authId, String type, SpanContext tracingContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(type);
        Span span = this.tracer.buildSpan("get Credentials by auth ID and type").addReference("child_of", tracingContext).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).withTag((Tag)TracingHelper.TAG_AUTH_ID, (Object)authId).withTag((Tag)TracingHelper.TAG_CREDENTIALS_TYPE, (Object)type).start();
        JsonObject filter = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withAuthId(authId).withType(type).document();
        if (LOG.isTraceEnabled()) {
            LOG.trace("retrieving credentials using filter:{}{}", (Object)System.lineSeparator(), (Object)filter.encodePrettily());
        }
        return this.mongoClient.findOne(this.collectionName, filter, PROJECTION_CREDS_BY_TYPE_AND_AUTH_ID).map(result -> {
            if (result == null) {
                throw new ClientErrorException(tenantId, 404, "no matching credentials on record");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("credentials data from collection:{}{}", (Object)System.lineSeparator(), (Object)result.encodePrettily());
            }
            CredentialsDto dto = (CredentialsDto)result.mapTo(CredentialsDto.class);
            dto.getCredentials().stream().forEach(cred -> cred.decryptFields(this.fieldLevelEncryption));
            return dto;
        }).onFailure(t -> {
            LOG.debug("error retrieving credentials by auth-id and type", t);
            TracingHelper.logError((Span)span, (String)"error retrieving credentials by auth-id and type", (Throwable)t);
        }).recover(this::mapError).onComplete(r -> span.finish());
    }

    @Override
    public Future<String> update(CredentialsDto credentials, Optional<String> resourceVersion, SpanContext tracingContext) {
        Objects.requireNonNull(credentials);
        Objects.requireNonNull(resourceVersion);
        Span span = this.tracer.buildSpan("update Credentials").addReference("child_of", tracingContext).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)credentials.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)credentials.getDeviceId()).start();
        resourceVersion.ifPresent(v -> TracingHelper.TAG_RESOURCE_VERSION.set(span, v));
        credentials.getCredentials().stream().forEach(cred -> cred.encryptFields(this.fieldLevelEncryption));
        JsonObject replaceCredentialsQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(credentials.getTenantId()).withDeviceId(credentials.getDeviceId()).document();
        JsonObject document = JsonObject.mapFrom((Object)credentials);
        if (LOG.isTraceEnabled()) {
            LOG.trace("updating credentials of device [tenant: {}, device-id: {}, resource-version; {}]:{}{}", new Object[]{credentials.getTenantId(), credentials.getDeviceId(), resourceVersion.orElse(null), System.lineSeparator(), document.encodePrettily()});
        }
        return this.mongoClient.findOneAndReplaceWithOptions(this.collectionName, replaceCredentialsQuery, document, new FindOptions(), new UpdateOptions().setReturningNewDocument(true)).compose(result -> {
            if (result == null) {
                return MongoDbBasedDao.checkForVersionMismatchAndFail(String.format("credentials [tenant-id: %s, device-id: %s]", credentials.getTenantId(), credentials.getDeviceId()), resourceVersion, this.getByDeviceId(credentials.getTenantId(), credentials.getDeviceId()));
            }
            LOG.debug("successfully updated credentials for device [tenant: {}, device-id: {}]", (Object)credentials.getTenantId(), (Object)credentials.getDeviceId());
            span.log("successfully updated credentials");
            if (LOG.isTraceEnabled()) {
                LOG.trace("new document in DB:{}{}", (Object)System.lineSeparator(), (Object)result.encodePrettily());
            }
            return Future.succeededFuture((Object)result.getString("version"));
        }).recover(error -> {
            if (MongoDbBasedDao.isDuplicateKeyError(error)) {
                return Future.failedFuture((Throwable)new ClientErrorException(credentials.getTenantId(), 409, "credentials (type, auth-id) must be unique for device"));
            }
            return Future.failedFuture((Throwable)error);
        }).onFailure(error -> {
            LOG.debug("error updating credentials", error);
            TracingHelper.logError((Span)span, (String)"error updating credentials", (Throwable)error);
        }).recover(this::mapError).onComplete(r -> span.finish());
    }

    @Override
    public Future<Void> delete(String tenantId, String deviceId, Optional<String> resourceVersion, SpanContext tracingContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(resourceVersion);
        Span span = this.tracer.buildSpan("delete Credentials").addReference("child_of", tracingContext).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)deviceId).start();
        resourceVersion.ifPresent(v -> TracingHelper.TAG_RESOURCE_VERSION.set(span, v));
        JsonObject removeCredentialsQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).withDeviceId(deviceId).document();
        return this.mongoClient.findOneAndDelete(this.collectionName, removeCredentialsQuery).compose(result -> {
            if (result == null) {
                return MongoDbBasedDao.checkForVersionMismatchAndFail(String.format("credentials [tenant-id: %s, device-id: %s]", tenantId, deviceId), resourceVersion, this.getByDeviceId(tenantId, deviceId));
            }
            span.log("successfully deleted credentials");
            LOG.debug("successfully deleted credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            return Future.succeededFuture((Object)null);
        }).onFailure(error -> {
            LOG.debug("error deleting credentials", error);
            TracingHelper.logError((Span)span, (String)"error deleting credentials", (Throwable)error);
        }).recover(this::mapError).onComplete(r -> span.finish());
    }

    @Override
    public Future<Void> delete(String tenantId, SpanContext tracingContext) {
        Objects.requireNonNull(tenantId);
        Span span = this.tracer.buildSpan("delete Credentials of all of Tenant's Devices").addReference("child_of", tracingContext).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).start();
        JsonObject removeCredentialsQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).document();
        return this.mongoClient.removeDocuments(this.collectionName, removeCredentialsQuery).compose(result -> {
            span.log("successfully deleted credentials");
            LOG.debug("successfully deleted credentials for devices of tenant [tenant-id: {}]", (Object)tenantId);
            return Future.succeededFuture((Object)null);
        }).recover(error -> {
            LOG.debug("error deleting credentials", error);
            TracingHelper.logError((Span)span, (String)"error deleting credentials", (Throwable)error);
            return this.mapError((Throwable)error);
        }).onComplete(r -> span.finish());
    }
}

