/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDao;
import org.eclipse.hono.deviceregistry.service.credentials.AbstractCredentialsManagementService;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.auth.HonoPasswordEncoder;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.service.management.credentials.CredentialsDto;
import org.eclipse.hono.tracing.TracingHelper;

public final class MongoDbBasedCredentialsManagementService
extends AbstractCredentialsManagementService {
    private final CredentialsDao dao;

    public MongoDbBasedCredentialsManagementService(Vertx vertx, CredentialsDao dao, MongoDbBasedCredentialsConfigProperties config, HonoPasswordEncoder passwordEncoder) {
        super(Objects.requireNonNull(vertx), Objects.requireNonNull(passwordEncoder), config.getMaxBcryptCostFactor(), config.getHashAlgorithmsWhitelist());
        Objects.requireNonNull(dao);
        Objects.requireNonNull(config);
        this.dao = dao;
    }

    protected Future<OperationResult<List<CommonCredential>>> processReadCredentials(DeviceKey deviceKey, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(span);
        return this.dao.getByDeviceId(deviceKey.getTenantId(), deviceKey.getDeviceId(), span.context()).map(dto -> OperationResult.ok((int)200, (Object)dto.getCredentials(), Optional.empty(), Optional.of(dto.getVersion())));
    }

    protected Future<OperationResult<Void>> processUpdateCredentials(DeviceKey deviceKey, List<CommonCredential> updatedCredentials, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(updatedCredentials);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceKey.getDeviceId());
        return this.dao.getByDeviceId(deviceKey.getTenantId(), deviceKey.getDeviceId(), span.context()).compose(existingCredentialsDto -> {
            List existingCredentials = existingCredentialsDto.getData();
            Promise result = Promise.promise();
            CredentialsDto updatedCredentialsDto = (CredentialsDto)CredentialsDto.forUpdate(() -> existingCredentialsDto, (Object)updatedCredentials, (String)DeviceRegistryUtils.getUniqueIdentifier());
            if (updatedCredentialsDto.requiresMerging()) {
                result.complete((Object)updatedCredentialsDto.merge(existingCredentials));
            } else {
                result.complete((Object)updatedCredentialsDto);
            }
            return result.future();
        }).compose(credentialsDto -> {
            credentialsDto.createMissingSecretIds();
            return this.dao.update((CredentialsDto)credentialsDto, resourceVersion, span.context());
        }).map(newVersion -> OperationResult.ok((int)204, (Object)null, Optional.empty(), Optional.of(newVersion)));
    }
}

