/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.app;

import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.mongo.HashStrategy;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.impl.DefaultHashStrategy;
import io.vertx.ext.auth.mongo.impl.MongoAuthenticationImpl;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.hono.deviceregistry.app.AbstractHttpServerFactory;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoAuthProviderConfig;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedHttpServiceConfigOptions;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedHttpServiceConfigProperties;
import org.eclipse.hono.deviceregistry.server.DeviceRegistryHttpServer;
import org.eclipse.hono.service.http.HttpServiceConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HttpServerFactory
extends AbstractHttpServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerFactory.class);
    @Inject
    MongoClient mongoClient;
    private MongoDbBasedHttpServiceConfigProperties httpServerProperties;

    @Inject
    void setHttpServerProperties(MongoDbBasedHttpServiceConfigOptions endpointOptions) {
        this.httpServerProperties = new MongoDbBasedHttpServiceConfigProperties(endpointOptions);
    }

    protected final HttpServiceConfigProperties getHttpServerProperties() {
        return this.httpServerProperties;
    }

    protected void customizeServer(DeviceRegistryHttpServer server) {
        if (this.httpServerProperties.isAuthenticationRequired()) {
            MongoAuthProviderConfig authConfig = this.httpServerProperties.getAuth();
            LOG.debug("creating AuthenticationHandler guarding access to registry's HTTP endpoint using configuration:{}{}", (Object)System.lineSeparator(), (Object)authConfig);
            MongoAuthenticationOptions mongoAuthOptions = new MongoAuthenticationOptions();
            mongoAuthOptions.setCollectionName(authConfig.getCollectionName());
            mongoAuthOptions.setUsernameField(authConfig.getUsernameField());
            mongoAuthOptions.setPasswordField(authConfig.getPasswordField());
            DefaultHashStrategy hashStrategy = new DefaultHashStrategy();
            Optional.ofNullable(authConfig.getHashAlgorithm()).ifPresent(arg_0 -> ((DefaultHashStrategy)hashStrategy).setAlgorithm(arg_0));
            Optional.ofNullable(authConfig.getSaltStyle()).ifPresent(arg_0 -> ((DefaultHashStrategy)hashStrategy).setSaltStyle(arg_0));
            MongoAuthenticationImpl mongoAuth = new MongoAuthenticationImpl(this.mongoClient, (HashStrategy)hashStrategy, authConfig.getSaltField(), mongoAuthOptions);
            server.setAuthHandler((AuthenticationHandler)BasicAuthHandler.create((AuthenticationProvider)mongoAuth, (String)this.httpServerProperties.getRealm()));
        }
    }
}

