/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceregistry.mongodb.model.DeviceDao;
import org.eclipse.hono.deviceregistry.service.device.AbstractRegistrationService;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.util.RegistrationResult;

public final class MongoDbBasedRegistrationService
extends AbstractRegistrationService {
    private final DeviceDao dao;

    public MongoDbBasedRegistrationService(DeviceDao deviceDao) {
        Objects.requireNonNull(deviceDao);
        this.dao = deviceDao;
    }

    protected Future<RegistrationResult> getRegistrationInformation(DeviceKey deviceKey, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(span);
        return this.dao.getById(deviceKey.getTenantId(), deviceKey.getDeviceId(), span.context()).map(dto -> RegistrationResult.from((int)200, (JsonObject)new JsonObject().put("device-id", deviceKey.getDeviceId()).put("data", JsonObject.mapFrom((Object)dto.getData())))).otherwise(t -> RegistrationResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t)));
    }

    protected Future<Set<String>> processResolveGroupMembers(String tenantId, Set<String> viaGroups, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(viaGroups);
        Objects.requireNonNull(span);
        return this.dao.resolveGroupMembers(tenantId, viaGroups, span.context());
    }
}

