/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDao;
import org.eclipse.hono.deviceregistry.service.credentials.AbstractCredentialsService;
import org.eclipse.hono.deviceregistry.service.credentials.CredentialKey;
import org.eclipse.hono.deviceregistry.service.tenant.TenantKey;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.CredentialsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedCredentialsService
extends AbstractCredentialsService {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedCredentialsService.class);
    private final MongoDbBasedCredentialsConfigProperties config;
    private final CredentialsDao dao;

    public MongoDbBasedCredentialsService(CredentialsDao dao, MongoDbBasedCredentialsConfigProperties config) {
        Objects.requireNonNull(dao);
        Objects.requireNonNull(config);
        this.dao = dao;
        this.config = config;
    }

    private static boolean isCredentialEnabled(JsonObject credential) {
        return Optional.ofNullable(credential.getBoolean("enabled")).orElse(true);
    }

    private CacheDirective getCacheDirective(String type) {
        if (this.config.getCacheMaxAge() > 0) {
            switch (type) {
                case "hashed-password": 
                case "x509-cert": {
                    return CacheDirective.maxAgeDirective((long)this.config.getCacheMaxAge());
                }
            }
            return CacheDirective.noCacheDirective();
        }
        return CacheDirective.noCacheDirective();
    }

    protected Future<CredentialsResult<JsonObject>> processGet(TenantKey tenant, CredentialKey key, JsonObject clientContext, Span span) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(key);
        Objects.requireNonNull(span);
        return this.dao.getByAuthIdAndType(tenant.getTenantId(), key.getAuthId(), key.getType(), span.context()).map(dto -> {
            LOG.trace("found credentials matching criteria");
            JsonObject json = JsonObject.mapFrom(dto.getCredentials().get(0));
            json.put("device-id", dto.getDeviceId());
            return Optional.of(json).filter(MongoDbBasedCredentialsService::isCredentialEnabled).filter(credential -> DeviceRegistryUtils.matchesWithClientContext((JsonObject)credential, (JsonObject)clientContext)).map(credential -> CredentialsResult.from((int)200, (Object)credential, (CacheDirective)this.getCacheDirective(key.getType()))).orElseThrow(() -> new ClientErrorException(tenant.getTenantId(), 404, "no matching credentials on record"));
        }).otherwise(t -> {
            LOG.debug("error retrieving credentials by auth-id", t);
            return CredentialsResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)t));
        });
    }
}

