/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.model;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoException;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceregistry.util.FieldLevelEncryption;
import org.eclipse.hono.service.management.BaseDto;
import org.eclipse.hono.service.management.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoDbBasedDao {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedDao.class);
    private static final String FIELD_SEARCH_RESOURCES_COUNT = "count";
    private static final String FIELD_SEARCH_RESOURCES_TOTAL_COUNT = String.format("$%s.%s", "total", "count");
    protected final Tracer tracer;
    protected final MongoClient mongoClient;
    protected final String collectionName;
    protected final FieldLevelEncryption fieldLevelEncryption;

    protected MongoDbBasedDao(MongoClient mongoClient, String collectionName, Tracer tracer, FieldLevelEncryption fieldLevelEncryption) {
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(collectionName);
        this.mongoClient = mongoClient;
        this.collectionName = collectionName;
        this.tracer = Optional.ofNullable(tracer).orElse((Tracer)NoopTracerFactory.create());
        this.fieldLevelEncryption = fieldLevelEncryption;
    }

    @PreDestroy
    public final void close() {
        if (this.mongoClient != null) {
            LOG.info("releasing connection to Mongo DB");
            this.mongoClient.close();
        }
    }

    protected static boolean isDuplicateKeyError(Throwable error) {
        Objects.requireNonNull(error);
        if (error instanceof MongoException) {
            MongoException mongoException = (MongoException)error;
            return ErrorCategory.fromErrorCode((int)mongoException.getCode()) == ErrorCategory.DUPLICATE_KEY;
        }
        return false;
    }

    protected Future<Void> createIndex(JsonObject keys, IndexOptions options) {
        Objects.requireNonNull(keys);
        Promise result = Promise.promise();
        LOG.debug("creating index [collection: {}]", (Object)this.collectionName);
        this.mongoClient.createIndexWithOptions(this.collectionName, keys, options, (Handler)result);
        return result.future().onSuccess(ok -> LOG.debug("successfully created index [collection: {}]", (Object)this.collectionName)).onFailure(t -> LOG.info("failed to create index [collection: {}]", (Object)this.collectionName, t));
    }

    protected <T> Future<SearchResult<T>> processSearchResource(int pageSize, int pageOffset, JsonObject filterDocument, JsonObject sortDocument, Function<JsonObject, List<T>> resultMapper) {
        Objects.requireNonNull(this.mongoClient);
        Objects.requireNonNull(this.collectionName);
        Objects.requireNonNull(filterDocument);
        Objects.requireNonNull(sortDocument);
        Objects.requireNonNull(resultMapper);
        JsonArray aggregationPipelineQuery = this.getSearchResourceQuery(pageSize, pageOffset, filterDocument, sortDocument);
        Promise searchPromise = Promise.promise();
        if (LOG.isTraceEnabled()) {
            LOG.trace("search resources aggregate pipeline query: [{}]", (Object)aggregationPipelineQuery.encodePrettily());
        }
        this.mongoClient.aggregate(this.collectionName, aggregationPipelineQuery).exceptionHandler(arg_0 -> ((Promise)searchPromise).fail(arg_0)).handler(arg_0 -> ((Promise)searchPromise).complete(arg_0));
        return searchPromise.future().map(result -> Optional.ofNullable(result.getInteger("total")).filter(total -> total > 0).map(total -> new SearchResult(total.intValue(), (List)resultMapper.apply((JsonObject)result))).orElseThrow(() -> new ClientErrorException(404))).recover(this::mapError);
    }

    private JsonArray getSearchResourceQuery(int pageSize, int pageOffset, JsonObject filterDocument, JsonObject sortDocument) {
        Objects.requireNonNull(filterDocument);
        Objects.requireNonNull(sortDocument);
        JsonArray aggregationQuery = new JsonArray();
        if (!filterDocument.isEmpty()) {
            aggregationQuery.add(new JsonObject().put("$match", filterDocument));
        }
        if (!sortDocument.isEmpty()) {
            aggregationQuery.add(new JsonObject().put("$sort", sortDocument));
        }
        JsonObject facetDocument = new JsonObject().put("total", new JsonArray().add(new JsonObject().put("$count", FIELD_SEARCH_RESOURCES_COUNT))).put("result", new JsonArray().add(new JsonObject().put("$skip", Integer.valueOf(pageOffset * pageSize))).add(new JsonObject().put("$limit", Integer.valueOf(pageSize))));
        aggregationQuery.add(new JsonObject().put("$facet", facetDocument));
        JsonObject projectDocument = new JsonObject().put("total", new JsonObject().put("$arrayElemAt", new JsonArray().add(FIELD_SEARCH_RESOURCES_TOTAL_COUNT).add(Integer.valueOf(0)))).put("result", Integer.valueOf(1));
        aggregationQuery.add(new JsonObject().put("$project", projectDocument));
        return aggregationQuery;
    }

    public final Future<Void> deleteAllFromCollection() {
        Promise result = Promise.promise();
        this.mongoClient.removeDocuments(this.collectionName, new JsonObject(), (Handler)result);
        return result.future().recover(this::mapError).mapEmpty();
    }

    protected final <T> Future<T> mapError(Throwable error) {
        if (error instanceof ServiceInvocationException) {
            return Future.failedFuture((Throwable)error);
        }
        return Future.failedFuture((Throwable)new ServerErrorException(500, error));
    }

    protected static <T> Future<T> checkForVersionMismatchAndFail(String resourceId, Optional<String> versionFromRequest, Future<? extends BaseDto<?>> resourceSupplierFuture) {
        Objects.requireNonNull(resourceId);
        Objects.requireNonNull(versionFromRequest);
        Objects.requireNonNull(resourceSupplierFuture);
        if (versionFromRequest.isPresent()) {
            return resourceSupplierFuture.compose(foundResource -> {
                if (!foundResource.getVersion().equals(versionFromRequest.get())) {
                    return Future.failedFuture((Throwable)new ClientErrorException(412, "resource version mismatch"));
                }
                return Future.failedFuture((Throwable)new ServerErrorException(500, "error modifying resource"));
            });
        }
        return Future.failedFuture((Throwable)new ClientErrorException(404, "no such object"));
    }
}

