/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.UpdateOptions;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDto;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbCallExecutor;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDocumentBuilder;
import org.eclipse.hono.deviceregistry.service.tenant.AbstractTenantManagementService;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.util.Versioned;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.management.Filter;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.SearchResult;
import org.eclipse.hono.service.management.Sort;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.service.management.tenant.TenantManagementService;
import org.eclipse.hono.service.management.tenant.TenantWithId;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.TenantResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedTenantService
extends AbstractTenantManagementService
implements TenantService,
TenantManagementService,
Lifecycle,
HealthCheckProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedTenantService.class);
    private final MongoClient mongoClient;
    private final MongoDbCallExecutor mongoDbCallExecutor;
    private final MongoDbBasedTenantsConfigProperties config;
    private final AtomicBoolean creatingIndices = new AtomicBoolean(false);
    private final AtomicBoolean indicesCreated = new AtomicBoolean(false);

    public MongoDbBasedTenantService(Vertx vertx, MongoClient mongoClient, MongoDbBasedTenantsConfigProperties config) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(config);
        this.mongoClient = mongoClient;
        this.mongoDbCallExecutor = new MongoDbCallExecutor(vertx, mongoClient);
        this.config = Objects.requireNonNull(config);
    }

    Future<Void> createIndices() {
        if (this.creatingIndices.compareAndSet(false, true)) {
            return this.mongoDbCallExecutor.createIndex(this.config.getCollectionName(), new JsonObject().put("tenant-id", Integer.valueOf(1)), new IndexOptions().unique(true)).compose(ok -> this.mongoDbCallExecutor.createIndex(this.config.getCollectionName(), new JsonObject().put("tenant.trusted-ca.subject-dn", Integer.valueOf(1)), new IndexOptions().unique(true).partialFilterExpression(new JsonObject().put("tenant.trusted-ca", new JsonObject().put("$exists", Boolean.valueOf(true)))))).onSuccess(ok -> this.indicesCreated.set(true)).onComplete(r -> this.creatingIndices.set(false));
        }
        return Future.failedFuture((Throwable)new ConcurrentModificationException("already trying to create indices"));
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register("tenants-indices-created-" + UUID.randomUUID(), status -> {
            if (this.indicesCreated.get()) {
                status.complete((Object)Status.OK());
            } else {
                LOG.debug("tenants-indices not (yet) created");
                status.complete((Object)Status.KO());
                this.createIndices();
            }
        });
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    public Future<Void> start() {
        this.createIndices();
        LOG.info("MongoDB Tenant service started");
        return Future.succeededFuture();
    }

    public Future<Void> stop() {
        this.mongoClient.close();
        return Future.succeededFuture();
    }

    protected Future<OperationResult<Void>> processUpdateTenant(String tenantId, Tenant tenantObj, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(tenantObj);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.modifyTenant(tenantId, tenantObj, resourceVersion, span));
    }

    private Future<OperationResult<Void>> modifyTenant(String tenantId, Tenant newTenant, Optional<String> resourceVersion, Span span) {
        JsonObject updateTenantQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).document();
        return this.findTenant(tenantId).map(existingDto -> (TenantDto)TenantDto.forUpdate(() -> existingDto, (Object)newTenant, (String)new Versioned((Object)newTenant).getVersion())).compose(newTenantDto -> {
            Promise updateTenantPromise = Promise.promise();
            this.mongoClient.findOneAndReplaceWithOptions(this.config.getCollectionName(), updateTenantQuery, JsonObject.mapFrom((Object)newTenantDto), new FindOptions(), new UpdateOptions().setReturningNewDocument(true), (Handler)updateTenantPromise);
            return updateTenantPromise.future();
        }).compose(updateResult -> Optional.ofNullable(updateResult).map(updated -> {
            span.log("successfully updated tenant");
            return Future.succeededFuture((Object)OperationResult.ok((int)204, (Object)null, Optional.empty(), Optional.of(updateResult.getString("version"))));
        }).orElseGet(() -> MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(tenantId, resourceVersion, this.findTenant(tenantId)))).recover(error -> {
            if (MongoDbDeviceRegistryUtils.isDuplicateKeyError(error)) {
                LOG.debug("conflict updating tenant [{}]. An existing tenant uses a certificate authority with the same Subject DN", (Object)tenantId, error);
                TracingHelper.logError((Span)span, (String)"an existing tenant uses a certificate authority with the same Subject DN", (Throwable)error);
                return Future.succeededFuture((Object)OperationResult.empty((int)409));
            }
            return Future.failedFuture((Throwable)error);
        });
    }

    protected Future<Result<Void>> processDeleteTenant(String tenantId, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> {
            JsonObject deleteTenantQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).document();
            Promise deleteTenantPromise = Promise.promise();
            this.mongoClient.findOneAndDelete(this.config.getCollectionName(), deleteTenantQuery, (Handler)deleteTenantPromise);
            return deleteTenantPromise.future().compose(tenantDtoResult -> Optional.ofNullable(tenantDtoResult).map(deleted -> {
                span.log("successfully deleted tenant");
                return Future.succeededFuture((Object)Result.from((int)204));
            }).orElseGet(() -> MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(tenantId, resourceVersion, this.findTenant(tenantId))));
        });
    }

    protected Future<OperationResult<SearchResult<TenantWithId>>> processSearchTenants(int pageSize, int pageOffset, List<Filter> filters, List<Sort> sortOptions, Span span) {
        Objects.requireNonNull(filters);
        Objects.requireNonNull(sortOptions);
        Objects.requireNonNull(span);
        JsonObject filterDocument = MongoDbDocumentBuilder.builder().withTenantFilters(filters).document();
        JsonObject sortDocument = MongoDbDocumentBuilder.builder().withTenantSortOptions(sortOptions).document();
        return MongoDbDeviceRegistryUtils.processSearchResource(this.mongoClient, this.config.getCollectionName(), pageSize, pageOffset, filterDocument, sortDocument, MongoDbBasedTenantService::getTenantsWithId);
    }

    public Future<TenantResult<JsonObject>> get(String tenantId) {
        return this.get(tenantId, (Span)NoopSpan.INSTANCE);
    }

    public Future<TenantResult<JsonObject>> get(String tenantId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(span);
        return this.readTenant(tenantId, span).compose(tenantDtoResult -> {
            if (tenantDtoResult.getStatus() != 200) {
                TracingHelper.logError((Span)span, (String)"tenant not found");
                return Future.succeededFuture((Object)TenantResult.from((int)404));
            }
            return Future.succeededFuture((Object)TenantResult.from((int)200, (Object)DeviceRegistryUtils.convertTenant((String)tenantId, (Tenant)((Tenant)tenantDtoResult.getPayload()), (boolean)true), (CacheDirective)DeviceRegistryUtils.getCacheDirective((long)this.config.getCacheMaxAge())));
        });
    }

    public Future<TenantResult<JsonObject>> get(X500Principal subjectDn) {
        return this.get(subjectDn, (Span)NoopSpan.INSTANCE);
    }

    public Future<TenantResult<JsonObject>> get(X500Principal subjectDn, Span span) {
        Objects.requireNonNull(subjectDn);
        Objects.requireNonNull(span);
        return this.findTenant(subjectDn).compose(tenantDtoResult -> Future.succeededFuture((Object)TenantResult.from((int)200, (Object)DeviceRegistryUtils.convertTenant((String)tenantDtoResult.getTenantId(), (Tenant)tenantDtoResult.getData(), (boolean)true), (CacheDirective)DeviceRegistryUtils.getCacheDirective((long)this.config.getCacheMaxAge())))).recover(error -> {
            TracingHelper.logError((Span)span, (String)"no tenant found for subject DN", (Throwable)error);
            return Future.succeededFuture((Object)TenantResult.from((int)404));
        });
    }

    protected Future<OperationResult<Tenant>> processReadTenant(String tenantId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(span);
        return this.findTenant(tenantId).compose(tenantDtoResult -> Future.succeededFuture((Object)OperationResult.ok((int)200, (Object)tenantDtoResult.getData(), Optional.ofNullable(DeviceRegistryUtils.getCacheDirective((long)this.config.getCacheMaxAge())), Optional.ofNullable(tenantDtoResult.getVersion()))));
    }

    private Future<TenantDto> findTenant(String tenantId) {
        Objects.requireNonNull(tenantId);
        JsonObject findTenantQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).document();
        return this.findTenant(findTenantQuery);
    }

    private Future<TenantDto> findTenant(X500Principal subjectDn) {
        Objects.requireNonNull(subjectDn);
        JsonObject findTenantQuery = MongoDbDocumentBuilder.builder().withCa(subjectDn.getName()).document();
        return this.findTenant(findTenantQuery);
    }

    private Future<TenantDto> findTenant(JsonObject findQuery) {
        Objects.requireNonNull(findQuery);
        Promise findTenantPromise = Promise.promise();
        this.mongoClient.findOne(this.config.getCollectionName(), findQuery, new JsonObject(), (Handler)findTenantPromise);
        return findTenantPromise.future().compose(tenantJsonResult -> Optional.ofNullable(tenantJsonResult).map(tenantJson -> Future.succeededFuture((Object)((Object)TenantDto.forRead(tenantJsonResult.getString("tenant-id"), (Tenant)tenantJsonResult.getJsonObject("tenant").mapTo(Tenant.class), tenantJsonResult.getInstant("created"), tenantJsonResult.getInstant("updatedOn"), tenantJsonResult.getString("version"))))).orElseGet(() -> Future.failedFuture((Throwable)new ClientErrorException(404))));
    }

    protected Future<OperationResult<Id>> processCreateTenant(String tenantId, Tenant tenantObj, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(tenantObj);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.addTenant(tenantId, tenantObj, span));
    }

    private Future<OperationResult<Id>> addTenant(String tenantId, Tenant tenantObj, Span span) {
        TenantDto newTenantDto = TenantDto.forCreation(tenantId, tenantObj, new Versioned((Object)tenantObj).getVersion());
        TracingHelper.TAG_TENANT_ID.set(span, tenantId);
        JsonObject newTenantDtoJson = JsonObject.mapFrom((Object)((Object)newTenantDto));
        Promise createTenantPromise = Promise.promise();
        this.mongoClient.insert(this.config.getCollectionName(), newTenantDtoJson, (Handler)createTenantPromise);
        return createTenantPromise.future().compose(tenantObjectIdResult -> {
            span.log("successfully created tenant");
            return Future.succeededFuture((Object)OperationResult.ok((int)201, (Object)Id.of((String)tenantId), Optional.empty(), Optional.of(newTenantDto.getVersion())));
        }).recover(error -> {
            if (MongoDbDeviceRegistryUtils.isDuplicateKeyError(error)) {
                LOG.debug("tenant [{}] already exists or an existing tenant uses a certificate authority with the same Subject DN", (Object)tenantId, error);
                TracingHelper.logError((Span)span, (String)"tenant with the given identifier already exists or an existing tenant uses a certificate authority with the same Subject DN", (Throwable)error);
                return Future.succeededFuture((Object)OperationResult.empty((int)409));
            }
            LOG.error("error adding tenant [{}]", (Object)tenantId, error);
            TracingHelper.logError((Span)span, (String)"error adding Tenant", (Throwable)error);
            return Future.succeededFuture((Object)OperationResult.empty((int)500));
        });
    }

    private static List<TenantWithId> getTenantsWithId(JsonObject searchResult) {
        return Optional.ofNullable(searchResult.getJsonArray("result")).map(tenants -> tenants.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(json -> (TenantDto)((Object)((Object)((Object)json.mapTo(TenantDto.class))))).map(tenantDto -> TenantWithId.from((String)tenantDto.getTenantId(), (Tenant)tenantDto.getData())).collect(Collectors.toList())).orElseGet(ArrayList::new);
    }
}

