/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb;

import io.micrometer.core.instrument.MeterRegistry;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.mongo.MongoAuth;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import java.util.Optional;
import org.eclipse.hono.adapter.client.telemetry.EventSender;
import org.eclipse.hono.adapter.client.telemetry.amqp.ProtonBasedDownstreamSender;
import org.eclipse.hono.adapter.client.telemetry.kafka.KafkaBasedEventSender;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.auth.SpringBasedHonoPasswordEncoder;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.client.kafka.KafkaProducerConfigProperties;
import org.eclipse.hono.client.kafka.KafkaProducerFactory;
import org.eclipse.hono.client.util.MessagingClient;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.config.VertxProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistrationConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedCredentialsService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedDeviceBackend;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedRegistrationService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedTenantService;
import org.eclipse.hono.deviceregistry.server.DeviceRegistryAmqpServer;
import org.eclipse.hono.deviceregistry.server.DeviceRegistryHttpServer;
import org.eclipse.hono.deviceregistry.service.device.AutoProvisioner;
import org.eclipse.hono.deviceregistry.service.device.AutoProvisionerConfigProperties;
import org.eclipse.hono.deviceregistry.service.tenant.DefaultTenantInformationService;
import org.eclipse.hono.deviceregistry.service.tenant.TenantInformationService;
import org.eclipse.hono.deviceregistry.util.ServiceClientAdapter;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.VertxBasedHealthCheckServer;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.service.credentials.DelegatingCredentialsAmqpEndpoint;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.service.http.HttpServiceConfigProperties;
import org.eclipse.hono.service.management.credentials.CredentialsManagementService;
import org.eclipse.hono.service.management.credentials.DelegatingCredentialsManagementHttpEndpoint;
import org.eclipse.hono.service.management.device.DelegatingDeviceManagementHttpEndpoint;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.service.management.tenant.DelegatingTenantManagementHttpEndpoint;
import org.eclipse.hono.service.management.tenant.TenantManagementService;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.service.metric.spring.PrometheusSupport;
import org.eclipse.hono.service.registration.DelegatingRegistrationAmqpEndpoint;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.service.tenant.DelegatingTenantAmqpEndpoint;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.MessagingType;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ObjectFactoryCreatingFactoryBean;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;

@Configuration
@Import(value={PrometheusSupport.class})
public class ApplicationConfig {
    private static final String BEAN_NAME_AMQP_SERVER = "amqpServer";
    private static final String BEAN_NAME_HTTP_SERVER = "httpServer";

    @Bean
    public Vertx vertx() {
        return Vertx.vertx((VertxOptions)this.vertxProperties().configureVertx(new VertxOptions()));
    }

    @ConfigurationProperties(value="hono.vertx")
    @Bean
    public VertxProperties vertxProperties() {
        return new VertxProperties();
    }

    @Bean
    public Tracer tracer() {
        return Optional.ofNullable(TracerResolver.resolveTracer()).orElse((Tracer)NoopTracerFactory.create());
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> commonTags() {
        return r -> r.config().commonTags((Iterable)MetricsTags.forService((String)"hono-registry"));
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.health-check")
    public ServerConfig healthCheckConfigProperties() {
        return new ServerConfig();
    }

    @Bean
    public HealthCheckServer healthCheckServer() {
        return new VertxBasedHealthCheckServer(this.vertx(), this.healthCheckConfigProperties());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.mongodb")
    public MongoDbConfigProperties mongoDbConfigProperties() {
        return new MongoDbConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public MongoClient mongoClient() {
        return MongoClient.createShared((Vertx)this.vertx(), (JsonObject)this.mongoDbConfigProperties().getMongoClientConfig());
    }

    @Bean
    public HonoPasswordEncoder passwordEncoder() {
        return new SpringBasedHonoPasswordEncoder(this.credentialsServiceProperties().getMaxBcryptCostFactor());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.registry.svc")
    public MongoDbBasedRegistrationConfigProperties registrationServiceProperties() {
        return new MongoDbBasedRegistrationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.tenant.svc")
    public MongoDbBasedTenantsConfigProperties tenantsServiceProperties() {
        return new MongoDbBasedTenantsConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.credentials.svc")
    public MongoDbBasedCredentialsConfigProperties credentialsServiceProperties() {
        return new MongoDbBasedCredentialsConfigProperties();
    }

    @Qualifier(value="amqp")
    @Bean
    @ConfigurationProperties(prefix="hono.registry.amqp")
    public ServiceConfigProperties amqpServerProperties() {
        return new ServiceConfigProperties();
    }

    @Bean(name={"amqpServer"})
    @Scope(value="prototype")
    public DeviceRegistryAmqpServer amqpServer() {
        return new DeviceRegistryAmqpServer();
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean amqpServerFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_AMQP_SERVER);
        return factory;
    }

    @Bean
    @ConfigurationProperties(prefix="hono.autoprovisioning")
    public AutoProvisionerConfigProperties autoProvisionerConfigProperties() {
        return new AutoProvisionerConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public MessagingClient<EventSender> eventSenders() {
        MessagingClient result = new MessagingClient();
        if (this.downstreamSenderConfig().isHostConfigured()) {
            result.setClient(MessagingType.amqp, (Lifecycle)new ProtonBasedDownstreamSender(HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.downstreamSenderConfig(), (Tracer)this.tracer()), SendMessageSampler.Factory.noop(), true, true));
        }
        if (this.kafkaProducerConfig().isConfigured()) {
            KafkaProducerFactory factory = KafkaProducerFactory.sharedProducerFactory((Vertx)this.vertx());
            result.setClient(MessagingType.kafka, (Lifecycle)new KafkaBasedEventSender(factory, this.kafkaProducerConfig(), true, this.tracer()));
        }
        this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)ServiceClientAdapter.forClient((ServiceClient)result));
        return result;
    }

    @ConfigurationProperties(prefix="hono.messaging")
    @Bean
    public ClientConfigProperties downstreamSenderConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        config.setNameIfNotSet("Device Registry");
        config.setServerRoleIfUnknown("AMQP Messaging Network");
        return config;
    }

    @ConfigurationProperties(prefix="hono.kafka")
    @Bean
    public KafkaProducerConfigProperties kafkaProducerConfig() {
        KafkaProducerConfigProperties configProperties = new KafkaProducerConfigProperties();
        configProperties.setDefaultClientIdPrefix("device-registry");
        return configProperties;
    }

    @Bean
    @Scope(value="prototype")
    public MongoDbBasedRegistrationService registrationService() {
        MongoDbBasedRegistrationService service = new MongoDbBasedRegistrationService(this.vertx(), this.mongoClient(), this.registrationServiceProperties());
        AutoProvisioner autoProvisioner = new AutoProvisioner();
        autoProvisioner.setVertx(this.vertx());
        autoProvisioner.setTracer(this.tracer());
        autoProvisioner.setDeviceManagementService((DeviceManagementService)service);
        autoProvisioner.setTenantInformationService(this.tenantInformationService());
        autoProvisioner.setEventSenders(this.eventSenders());
        autoProvisioner.setConfig(this.autoProvisionerConfigProperties());
        service.setAutoProvisioner(autoProvisioner);
        this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)service);
        return service;
    }

    @Bean
    @Scope(value="prototype")
    public MongoDbBasedCredentialsService credentialsService() {
        MongoDbBasedCredentialsService service = new MongoDbBasedCredentialsService(this.vertx(), this.mongoClient(), this.credentialsServiceProperties(), this.passwordEncoder());
        this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)service);
        return service;
    }

    @Bean
    @Scope(value="prototype")
    public MongoDbBasedTenantService tenantService() {
        MongoDbBasedTenantService service = new MongoDbBasedTenantService(this.vertx(), this.mongoClient(), this.tenantsServiceProperties());
        this.healthCheckServer().registerHealthCheckResources((HealthCheckProvider)service);
        return service;
    }

    @Bean
    @Scope(value="prototype")
    public TenantInformationService tenantInformationService() {
        return new DefaultTenantInformationService((TenantManagementService)this.tenantService());
    }

    @Bean
    @Scope(value="prototype")
    public AmqpEndpoint registrationAmqpEndpoint() {
        return new DelegatingRegistrationAmqpEndpoint(this.vertx(), (RegistrationService)this.registrationService());
    }

    @Bean
    @Scope(value="prototype")
    public AmqpEndpoint credentialsAmqpEndpoint() {
        MongoDbBasedDeviceBackend service = new MongoDbBasedDeviceBackend(this.registrationService(), this.credentialsService(), this.tenantInformationService());
        return new DelegatingCredentialsAmqpEndpoint(this.vertx(), (CredentialsService)service);
    }

    @Bean
    @Scope(value="prototype")
    public AmqpEndpoint tenantAmqpEndpoint() {
        return new DelegatingTenantAmqpEndpoint(this.vertx(), (TenantService)this.tenantService());
    }

    @Qualifier(value="http")
    @Bean
    @ConfigurationProperties(prefix="hono.registry.http")
    public HttpServiceConfigProperties httpServerProperties() {
        return new HttpServiceConfigProperties();
    }

    @Bean(name={"httpServer"})
    @Scope(value="prototype")
    public DeviceRegistryHttpServer httpServer() {
        return new DeviceRegistryHttpServer();
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean httpServerFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_HTTP_SERVER);
        return factory;
    }

    @Bean
    @Scope(value="prototype")
    public AuthHandler createAuthHandler(HttpServiceConfigProperties httpServiceConfigProperties) {
        if (httpServiceConfigProperties.isAuthenticationRequired()) {
            return BasicAuthHandler.create((AuthProvider)MongoAuth.create((MongoClient)this.mongoClient(), (JsonObject)new JsonObject()), (String)this.httpServerProperties().getRealm());
        }
        return null;
    }

    @Bean
    @Scope(value="prototype")
    public HttpEndpoint deviceHttpEndpoint() {
        MongoDbBasedDeviceBackend service = new MongoDbBasedDeviceBackend(this.registrationService(), this.credentialsService(), this.tenantInformationService());
        return new DelegatingDeviceManagementHttpEndpoint(this.vertx(), (DeviceManagementService)service);
    }

    @Bean
    @Scope(value="prototype")
    public HttpEndpoint credentialsHttpEndpoint() {
        return new DelegatingCredentialsManagementHttpEndpoint(this.vertx(), (CredentialsManagementService)this.credentialsService());
    }

    @Bean
    @Scope(value="prototype")
    public HttpEndpoint tenantHttpEndpoint() {
        return new DelegatingTenantManagementHttpEndpoint(this.vertx(), (TenantManagementService)this.tenantService());
    }
}

