/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoException;
import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.deviceregistry.mongodb.config.AbstractMongoDbBasedRegistryConfigProperties;
import org.eclipse.hono.service.management.BaseDto;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.SearchResult;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbDeviceRegistryUtils {
    public static final String FIELD_CREDENTIALS = "credentials";
    public static final String FIELD_DEVICE = "device";
    public static final String FIELD_CREATED = "created";
    public static final String FIELD_UPDATED_ON = "updatedOn";
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_AUTO_PROVISIONED = "autoProvisioned";
    public static final String FIELD_AUTO_PROVISIONING_NOTIFICATION_SENT = "autoProvisioningNotificationSent";
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbDeviceRegistryUtils.class);
    private static final String FIELD_SEARCH_RESOURCES_COUNT = "count";
    private static final String FIELD_SEARCH_RESOURCES_TOTAL_COUNT = String.format("$%s.%s", "total", "count");

    private MongoDbDeviceRegistryUtils() {
    }

    public static Future<Void> isModificationEnabled(AbstractMongoDbBasedRegistryConfigProperties config) {
        Objects.requireNonNull(config);
        if (config.isModificationEnabled()) {
            return Future.succeededFuture();
        }
        return Future.failedFuture((Throwable)new ClientErrorException(403, "modification is disabled"));
    }

    public static <T> OperationResult<T> mapErrorToResult(Throwable error, Span span) {
        Objects.requireNonNull(error);
        LOG.debug(error.getMessage(), error);
        TracingHelper.logError((Span)span, (String)error.getMessage(), (Throwable)error);
        if (error instanceof IllegalArgumentException) {
            return OperationResult.empty((int)400);
        }
        return OperationResult.empty((int)ServiceInvocationException.extractStatusCode((Throwable)error));
    }

    public static <T> Future<T> checkForVersionMismatchAndFail(String resourceId, Optional<String> versionFromRequest, Future<? extends BaseDto> resourceSupplierFuture) {
        Objects.requireNonNull(resourceId);
        Objects.requireNonNull(versionFromRequest);
        Objects.requireNonNull(resourceSupplierFuture);
        if (versionFromRequest.isPresent()) {
            return resourceSupplierFuture.compose(foundResource -> {
                if (!foundResource.getVersion().equals(versionFromRequest.get())) {
                    return Future.failedFuture((Throwable)new ClientErrorException(412, "Resource version mismatch"));
                }
                return Future.failedFuture((Throwable)new ServerErrorException(500, String.format("Error modifying resource [%s].", resourceId)));
            });
        }
        return Future.failedFuture((Throwable)new ClientErrorException(404, String.format("Resource [%s] not found.", resourceId)));
    }

    public static boolean isDuplicateKeyError(Throwable error) {
        Objects.requireNonNull(error);
        if (error instanceof MongoException) {
            MongoException mongoException = (MongoException)error;
            return ErrorCategory.fromErrorCode((int)mongoException.getCode()) == ErrorCategory.DUPLICATE_KEY;
        }
        return false;
    }

    public static <T> Future<OperationResult<SearchResult<T>>> processSearchResource(MongoClient mongoClient, String collectionName, int pageSize, int pageOffset, JsonObject filterDocument, JsonObject sortDocument, Function<JsonObject, List<T>> resultMapper) {
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(filterDocument);
        Objects.requireNonNull(sortDocument);
        Objects.requireNonNull(resultMapper);
        JsonArray aggregationPipelineQuery = MongoDbDeviceRegistryUtils.getSearchResourceQuery(pageSize, pageOffset, filterDocument, sortDocument);
        Promise searchPromise = Promise.promise();
        if (LOG.isTraceEnabled()) {
            LOG.trace("search resources aggregate pipeline query: [{}]", (Object)aggregationPipelineQuery.encodePrettily());
        }
        mongoClient.aggregate(collectionName, aggregationPipelineQuery).exceptionHandler(arg_0 -> ((Promise)searchPromise).fail(arg_0)).handler(arg_0 -> ((Promise)searchPromise).complete(arg_0));
        return searchPromise.future().map(result -> Optional.ofNullable(result.getInteger("total")).filter(total -> total > 0).map(total -> OperationResult.ok((int)200, (Object)new SearchResult(total.intValue(), (List)resultMapper.apply((JsonObject)result)), Optional.empty(), Optional.empty())).orElseThrow(() -> new ClientErrorException(404)));
    }

    private static JsonArray getSearchResourceQuery(int pageSize, int pageOffset, JsonObject filterDocument, JsonObject sortDocument) {
        Objects.requireNonNull(filterDocument);
        Objects.requireNonNull(sortDocument);
        JsonArray aggregationQuery = new JsonArray();
        if (!filterDocument.isEmpty()) {
            aggregationQuery.add(new JsonObject().put("$match", filterDocument));
        }
        if (!sortDocument.isEmpty()) {
            aggregationQuery.add(new JsonObject().put("$sort", sortDocument));
        }
        JsonObject facetDocument = new JsonObject().put("total", new JsonArray().add(new JsonObject().put("$count", FIELD_SEARCH_RESOURCES_COUNT))).put("result", new JsonArray().add(new JsonObject().put("$skip", Integer.valueOf(pageOffset * pageSize))).add(new JsonObject().put("$limit", Integer.valueOf(pageSize))));
        aggregationQuery.add(new JsonObject().put("$facet", facetDocument));
        JsonObject projectDocument = new JsonObject().put("total", new JsonObject().put("$arrayElemAt", new JsonArray().add(FIELD_SEARCH_RESOURCES_TOTAL_COUNT).add(Integer.valueOf(0)))).put("result", Integer.valueOf(1));
        aggregationQuery.add(new JsonObject().put("$project", projectDocument));
        return aggregationQuery;
    }
}

