/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbCallExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbCallExecutor.class);
    private final MongoClient mongoClient;
    private final Vertx vertx;

    public MongoDbCallExecutor(Vertx vertx, MongoClient mongoClient) {
        this.vertx = Objects.requireNonNull(vertx);
        this.mongoClient = Objects.requireNonNull(mongoClient);
    }

    public Future<Void> createIndex(String collectionName, JsonObject keys, IndexOptions options) {
        Objects.requireNonNull(collectionName);
        Objects.requireNonNull(keys);
        Promise result = Promise.promise();
        this.vertx.runOnContext(s -> {
            LOG.debug("creating index [collection: {}]", (Object)collectionName);
            this.mongoClient.createIndexWithOptions(collectionName, keys, options, (Handler)result);
        });
        return result.future().onSuccess(ok -> LOG.debug("successfully created index [collection: {}]", (Object)collectionName)).onFailure(t -> LOG.info("failed to create index [collection: {}]", (Object)collectionName, t));
    }
}

