/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.management.BaseDto;
import org.eclipse.hono.service.management.Filter;
import org.eclipse.hono.service.management.Sort;
import org.eclipse.hono.service.management.device.DeviceDto;

public final class MongoDbDocumentBuilder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonPointer FIELD_ID = JsonPointer.from((String)"/id");
    private static final String TENANT_TRUSTED_CA_SUBJECT_PATH = String.format("%s.%s.%s", "tenant", "trusted-ca", "subject-dn");
    private static final String MONGODB_OPERATOR_ELEM_MATCH = "$elemMatch";
    private static final String MONGODB_OPERATOR_SET = "$set";
    private final JsonObject document = new JsonObject();

    private MongoDbDocumentBuilder() {
    }

    public static MongoDbDocumentBuilder builder() {
        return new MongoDbDocumentBuilder();
    }

    public MongoDbDocumentBuilder forUpdateOf(DeviceDto deviceDto) {
        this.forUpdateOf((BaseDto<?>)deviceDto);
        JsonObject updateDocument = this.document.getJsonObject(MONGODB_OPERATOR_SET);
        if (deviceDto.getDeviceStatus().getAutoProvisioningNotificationSentSetInternal() != null) {
            updateDocument.put("autoProvisioningNotificationSent", deviceDto.getDeviceStatus().getAutoProvisioningNotificationSentSetInternal());
        }
        return this;
    }

    public MongoDbDocumentBuilder forUpdateOf(BaseDto<?> baseDto) {
        JsonObject updates = new JsonObject();
        if (baseDto.getData() != null) {
            JavaType baseDtoJavaType = OBJECT_MAPPER.getTypeFactory().constructType(baseDto.getClass());
            BeanDescription beanDescription = OBJECT_MAPPER.getSerializationConfig().introspect(baseDtoJavaType);
            AnnotatedMethod getDataMethod = beanDescription.findMethod("getData", null);
            JsonProperty jsonProperty = (JsonProperty)getDataMethod.getAnnotation(JsonProperty.class);
            updates.put(jsonProperty.value(), JsonObject.mapFrom((Object)baseDto.getData()));
        }
        if (baseDto.getCreationTime() != null) {
            updates.put("created", baseDto.getCreationTime());
        }
        if (baseDto.getUpdatedOn() != null) {
            updates.put("updatedOn", baseDto.getUpdatedOn());
        }
        if (baseDto.getVersion() != null) {
            updates.put("version", baseDto.getVersion());
        }
        this.document.put(MONGODB_OPERATOR_SET, updates);
        return this;
    }

    public MongoDbDocumentBuilder withTenantId(String tenantId) {
        this.document.put("tenant-id", tenantId);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceId(String deviceId) {
        this.document.put("device-id", deviceId);
        return this;
    }

    public MongoDbDocumentBuilder withCa(String subjectDn) {
        this.document.put(TENANT_TRUSTED_CA_SUBJECT_PATH, new JsonObject().put("$eq", subjectDn));
        return this;
    }

    public MongoDbDocumentBuilder withVersion(Optional<String> version) {
        Objects.requireNonNull(version);
        version.ifPresent(ver -> this.document.put("version", ver));
        return this;
    }

    public JsonObject document() {
        return this.document;
    }

    public MongoDbDocumentBuilder withType(String type) {
        return this.withCredentialsPredicate("type", type);
    }

    public MongoDbDocumentBuilder withAuthId(String authId) {
        return this.withCredentialsPredicate("auth-id", authId);
    }

    private MongoDbDocumentBuilder withCredentialsPredicate(String field, String value) {
        JsonObject credentialsArraySpec = this.document.getJsonObject("credentials", new JsonObject());
        JsonObject elementMatchSpec = credentialsArraySpec.getJsonObject(MONGODB_OPERATOR_ELEM_MATCH, new JsonObject());
        elementMatchSpec.put(field, value);
        credentialsArraySpec.put(MONGODB_OPERATOR_ELEM_MATCH, elementMatchSpec);
        this.document.put("credentials", credentialsArraySpec);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceFilters(List<Filter> filters) {
        Objects.requireNonNull(filters);
        this.applySearchFilters(filters, MongoDbDocumentBuilder::mapDeviceField);
        return this;
    }

    public MongoDbDocumentBuilder withTenantFilters(List<Filter> filters) {
        Objects.requireNonNull(filters);
        this.applySearchFilters(filters, MongoDbDocumentBuilder::mapTenantField);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceSortOptions(List<Sort> sortOptions) {
        Objects.requireNonNull(sortOptions);
        this.applySortingOptions(sortOptions, MongoDbDocumentBuilder::mapDeviceField);
        return this;
    }

    public MongoDbDocumentBuilder withTenantSortOptions(List<Sort> sortOptions) {
        Objects.requireNonNull(sortOptions);
        this.applySortingOptions(sortOptions, MongoDbDocumentBuilder::mapTenantField);
        return this;
    }

    private void applySearchFilters(List<Filter> filters, Function<JsonPointer, String> fieldMapper) {
        filters.forEach(filter -> {
            if (filter.getValue() instanceof String) {
                String value = (String)filter.getValue();
                this.document.put((String)fieldMapper.apply(filter.getField()), new JsonObject().put("$regex", DeviceRegistryUtils.getRegexExpressionForSearchOperation((String)value)));
            } else {
                this.document.put((String)fieldMapper.apply(filter.getField()), filter.getValue());
            }
        });
    }

    private void applySortingOptions(List<Sort> sortOptions, Function<JsonPointer, String> fieldMapper) {
        sortOptions.forEach(sortOption -> this.document.put((String)fieldMapper.apply(sortOption.getField()), Integer.valueOf(MongoDbDocumentBuilder.mapSortingDirection(sortOption.getDirection()))));
    }

    private static String mapDeviceField(JsonPointer field) {
        if (FIELD_ID.equals(field)) {
            return "device-id";
        }
        return "device" + field.toString().replace("/", ".");
    }

    private static String mapTenantField(JsonPointer field) {
        if (FIELD_ID.equals(field)) {
            return "tenant-id";
        }
        return "tenant" + field.toString().replace("/", ".");
    }

    private static int mapSortingDirection(Sort.Direction direction) {
        if (direction == Sort.Direction.asc) {
            return 1;
        }
        return -1;
    }
}

