/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import com.google.common.base.MoreObjects;
import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.Tags;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedCredentialsService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedRegistrationService;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.management.Filter;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.SearchResult;
import org.eclipse.hono.service.management.Sort;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.service.management.device.AutoProvisioningEnabledDeviceBackend;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceWithId;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CredentialsResult;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.RegistrationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbBasedDeviceBackend
implements AutoProvisioningEnabledDeviceBackend,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedDeviceBackend.class);
    private final MongoDbBasedRegistrationService registrationService;
    private final MongoDbBasedCredentialsService credentialsService;

    public MongoDbBasedDeviceBackend(MongoDbBasedRegistrationService registrationService, MongoDbBasedCredentialsService credentialsService) {
        this.registrationService = registrationService;
        this.credentialsService = credentialsService;
    }

    public Future<Void> start() {
        LOG.debug("starting up services");
        return CompositeFuture.all((Future)this.registrationService.start(), this.credentialsService.start()).mapEmpty();
    }

    public Future<Void> stop() {
        LOG.debug("stopping services");
        return CompositeFuture.join((Future)this.registrationService.stop(), this.credentialsService.stop()).mapEmpty();
    }

    public Future<RegistrationResult> assertRegistration(String tenantId, String deviceId) {
        return this.registrationService.assertRegistration(tenantId, deviceId);
    }

    public Future<RegistrationResult> assertRegistration(String tenantId, String deviceId, String gatewayId) {
        return this.registrationService.assertRegistration(tenantId, deviceId, gatewayId);
    }

    public Future<OperationResult<Device>> readDevice(String tenantId, String deviceId, Span span) {
        return this.registrationService.readDevice(tenantId, deviceId, span);
    }

    public Future<OperationResult<SearchResult<DeviceWithId>>> searchDevices(String tenantId, int pageSize, int pageOffset, List<Filter> filters, List<Sort> sortOptions, Span span) {
        return this.registrationService.searchDevices(tenantId, pageSize, pageOffset, filters, sortOptions, span);
    }

    public Future<Result<Void>> deleteDevice(String tenantId, String deviceId, Optional<String> resourceVersion, Span span) {
        return this.registrationService.deleteDevice(tenantId, deviceId, resourceVersion, span).compose(result -> {
            if (result.getStatus() != 204) {
                return Future.succeededFuture((Object)result);
            }
            return this.credentialsService.removeCredentials(tenantId, deviceId, span).map(result);
        });
    }

    public Future<OperationResult<Id>> createDevice(String tenantId, Optional<String> deviceId, Device device, Span span) {
        return this.registrationService.createDevice(tenantId, deviceId, device, span).compose(result -> {
            if (result.getStatus() != 201) {
                return Future.succeededFuture((Object)result);
            }
            return this.credentialsService.addCredentials(tenantId, ((Id)result.getPayload()).getId(), Collections.emptyList(), Optional.empty(), span).map(result);
        });
    }

    public Future<OperationResult<Id>> updateDevice(String tenantId, String deviceId, Device device, Optional<String> resourceVersion, Span span) {
        return this.registrationService.updateDevice(tenantId, deviceId, device, resourceVersion, span);
    }

    public final Future<CredentialsResult<JsonObject>> get(String tenantId, String type, String authId) {
        return this.credentialsService.get(tenantId, type, authId);
    }

    public Future<CredentialsResult<JsonObject>> get(String tenantId, String type, String authId, Span span) {
        return this.credentialsService.get(tenantId, type, authId, span);
    }

    public final Future<CredentialsResult<JsonObject>> get(String tenantId, String type, String authId, JsonObject clientContext) {
        return this.get(tenantId, type, authId, clientContext, (Span)NoopSpan.INSTANCE);
    }

    public Future<CredentialsResult<JsonObject>> get(String tenantId, String type, String authId, JsonObject clientContext, Span span) {
        return this.credentialsService.get(tenantId, type, authId, clientContext, span).compose(result -> {
            if (result.getStatus() == 404 && this.isAutoProvisioningEnabled(type, clientContext)) {
                Tags.ERROR.set(span, Boolean.FALSE);
                return DeviceRegistryUtils.getCertificateFromClientContext((String)tenantId, (String)authId, (JsonObject)clientContext, (Span)span).compose(optionalCert -> optionalCert.map(ok -> this.provisionDevice(tenantId, (X509Certificate)optionalCert.get(), span).compose(r -> {
                    if (r.isError()) {
                        TracingHelper.logError((Span)span, (String)((String)r.getPayload()));
                        return Future.succeededFuture(this.createErrorCredentialsResult(r.getStatus(), (String)r.getPayload()));
                    }
                    return this.getNewCredentials(tenantId, authId, span);
                })).orElseGet(() -> Future.succeededFuture((Object)result)));
            }
            return Future.succeededFuture((Object)result);
        });
    }

    private Future<CredentialsResult<JsonObject>> getNewCredentials(String tenantId, String authId, Span span) {
        return this.credentialsService.get(tenantId, "x509-cert", authId, span).map(r -> r.isOk() ? CredentialsResult.from((int)201, (Object)((JsonObject)r.getPayload())) : r);
    }

    private boolean isAutoProvisioningEnabled(String type, JsonObject clientContext) {
        return type.equals("x509-cert") && clientContext != null && clientContext.containsKey("client-certificate");
    }

    private CredentialsResult<JsonObject> createErrorCredentialsResult(int status, String message) {
        return CredentialsResult.from((int)status, (Object)new JsonObject().put("description", message));
    }

    public Future<OperationResult<Void>> updateCredentials(String tenantId, String deviceId, List<CommonCredential> credentials, Optional<String> resourceVersion, Span span) {
        return this.credentialsService.updateCredentials(tenantId, deviceId, credentials, resourceVersion, span);
    }

    public Future<OperationResult<List<CommonCredential>>> readCredentials(String tenantId, String deviceId, Span span) {
        return this.credentialsService.readCredentials(tenantId, deviceId, span).compose(result -> {
            if (result.getStatus() == 404) {
                return this.registrationService.readDevice(tenantId, deviceId, span).map(d -> {
                    if (d.getStatus() == 200) {
                        return OperationResult.ok((int)200, Collections.emptyList(), (Optional)result.getCacheDirective(), (Optional)result.getResourceVersion());
                    }
                    return result;
                });
            }
            return Future.succeededFuture((Object)result);
        });
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("credentialsService", (Object)this.credentialsService).add("registrationService", (Object)this.registrationService);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }
}

