/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.management.BaseDto;
import org.eclipse.hono.service.management.credentials.CommonCredential;

public final class CredentialsDto
extends BaseDto<List<CommonCredential>> {
    @JsonProperty(value="tenant-id", required=true)
    private String tenantId;
    @JsonProperty(value="device-id", required=true)
    private String deviceId;
    private boolean requiresMerging;

    public static CredentialsDto forCreation(String tenantId, String deviceId, List<CommonCredential> credentials, String version) {
        CredentialsDto credentialsDto = (CredentialsDto)BaseDto.forCreation(CredentialsDto::new, credentials, (String)version);
        credentialsDto.setTenantId(tenantId);
        credentialsDto.setDeviceId(deviceId);
        return credentialsDto;
    }

    public static CredentialsDto forUpdate(String tenantId, String deviceId, List<CommonCredential> credentials, String version) {
        CredentialsDto credentialsDto = (CredentialsDto)BaseDto.forUpdate(CredentialsDto::new, credentials, (String)version);
        credentialsDto.setTenantId(tenantId);
        credentialsDto.setDeviceId(deviceId);
        return credentialsDto;
    }

    @JsonIgnore
    private void assertSecretIdUniqueness(List<? extends CommonCredential> credentials) {
        credentials.stream().map(CommonCredential::getSecrets).forEach(secrets -> {
            HashSet secretIds = new HashSet();
            AtomicInteger count = new AtomicInteger(0);
            secrets.stream().forEach(secret -> {
                if (secret.getId() != null) {
                    this.requiresMerging = true;
                    secretIds.add(secret.getId());
                    count.incrementAndGet();
                }
            });
            if (secretIds.size() < count.get()) {
                throw new ClientErrorException(400, "secret IDs must be unique within each credentials object");
            }
        });
    }

    public String getTenantId() {
        return this.tenantId;
    }

    private void setTenantId(String tenantId) {
        this.tenantId = Objects.requireNonNull(tenantId);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    private void setDeviceId(String deviceId) {
        this.deviceId = Objects.requireNonNull(deviceId);
    }

    public List<CommonCredential> getCredentials() {
        return this.getData();
    }

    protected void setData(List<CommonCredential> data) {
        Optional.ofNullable(data).ifPresent(creds -> this.assertSecretIdUniqueness((List<? extends CommonCredential>)creds));
        super.setData(data);
    }

    @JsonIgnore
    public boolean requiresMerging() {
        return this.requiresMerging;
    }

    public void createMissingSecretIds() {
        Optional.ofNullable(this.getData()).ifPresent(creds -> creds.stream().forEach(CommonCredential::createMissingSecretIds));
    }

    @JsonIgnore
    public CredentialsDto merge(CredentialsDto otherCredentialsDto) {
        Objects.requireNonNull(otherCredentialsDto);
        Optional.ofNullable(otherCredentialsDto.getCredentials()).ifPresent(credentialsToMerge -> this.getData().forEach(credential -> CredentialsDto.findCredentialByIdAndType(credential.getAuthId(), credential.getType(), credentialsToMerge).ifPresent(arg_0 -> ((CommonCredential)credential).merge(arg_0))));
        this.setUpdatedOn(Instant.now());
        return this;
    }

    @JsonIgnore
    private static Optional<CommonCredential> findCredentialByIdAndType(String authId, String authType, List<CommonCredential> credentials) {
        return credentials.stream().filter(credential -> authId.equals(credential.getAuthId()) && authType.equals(credential.getType())).findFirst();
    }

    @JsonProperty(value="credentials", required=true)
    public List<CommonCredential> getData() {
        return (List)super.getData();
    }
}

