/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.UpdateOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistrationConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.MongoDbBasedDeviceDto;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbCallExecutor;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDocumentBuilder;
import org.eclipse.hono.deviceregistry.service.device.AbstractRegistrationService;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.util.Versioned;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.management.Filter;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.SearchResult;
import org.eclipse.hono.service.management.Sort;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceDto;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.service.management.device.DeviceWithId;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.RegistrationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedRegistrationService
extends AbstractRegistrationService
implements DeviceManagementService,
Lifecycle,
HealthCheckProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedRegistrationService.class);
    private static final String PROPERTY_DEVICE_MEMBER_OF = String.format("%s.%s", "device", "memberOf");
    private final MongoClient mongoClient;
    private final MongoDbBasedRegistrationConfigProperties config;
    private final MongoDbCallExecutor mongoDbCallExecutor;
    private final AtomicBoolean creatingIndices = new AtomicBoolean(false);
    private final AtomicBoolean indicesCreated = new AtomicBoolean(false);

    public MongoDbBasedRegistrationService(Vertx vertx, MongoClient mongoClient, MongoDbBasedRegistrationConfigProperties config) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(config);
        this.mongoClient = mongoClient;
        this.mongoDbCallExecutor = new MongoDbCallExecutor(vertx, mongoClient);
        this.config = config;
    }

    Future<Void> createIndices() {
        if (this.creatingIndices.compareAndSet(false, true)) {
            return this.mongoDbCallExecutor.createIndex(this.config.getCollectionName(), new JsonObject().put("tenant-id", Integer.valueOf(1)).put("device-id", Integer.valueOf(1)), new IndexOptions().unique(true)).onSuccess(ok -> this.indicesCreated.set(true)).onComplete(r -> this.creatingIndices.set(false));
        }
        return Future.failedFuture((Throwable)new ConcurrentModificationException("already trying to create indices"));
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register("devices-indices-created-" + UUID.randomUUID(), status -> {
            if (this.indicesCreated.get()) {
                status.complete((Object)Status.OK());
            } else {
                LOG.debug("devices-indices not (yet) created");
                status.complete((Object)Status.KO());
                this.createIndices();
            }
        });
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    public Future<Void> startInternal() {
        this.createIndices();
        LOG.info("MongoDB Device Registration service started");
        return Future.succeededFuture();
    }

    public Future<Void> stopInternal() {
        this.mongoClient.close();
        return Future.succeededFuture();
    }

    public Future<OperationResult<Id>> createDevice(String tenantId, Optional<String> deviceId, Device device, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.tenantExists(tenantId, span)).compose(ok -> this.isMaxDevicesLimitReached(tenantId)).compose(ok -> {
            DeviceDto deviceDto = DeviceDto.forCreation(MongoDbBasedDeviceDto::new, (String)tenantId, (String)deviceId.orElseGet(() -> DeviceRegistryUtils.getUniqueIdentifier()), (Boolean)(device.getStatus() != null ? device.getStatus().isAutoProvisioned() : false), (Device)device, (String)new Versioned((Object)device).getVersion());
            return this.processCreateDevice(deviceDto, span);
        }).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<OperationResult<Device>> readDevice(String tenantId, String deviceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        return this.tenantExists(tenantId, span).compose(ok -> this.processReadDevice(tenantId, deviceId)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<OperationResult<SearchResult<DeviceWithId>>> searchDevices(String tenantId, int pageSize, int pageOffset, List<Filter> filters, List<Sort> sortOptions, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(filters);
        Objects.requireNonNull(sortOptions);
        Objects.requireNonNull(span);
        return this.tenantExists(tenantId, span).compose(ok -> {
            JsonObject filterDocument = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withDeviceFilters(filters).document();
            JsonObject sortDocument = MongoDbDocumentBuilder.builder().withDeviceSortOptions(sortOptions).document();
            return MongoDbDeviceRegistryUtils.processSearchResource(this.mongoClient, this.config.getCollectionName(), pageSize, pageOffset, filterDocument, sortDocument, MongoDbBasedRegistrationService::getDevicesWithId);
        }).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<OperationResult<Id>> updateDevice(String tenantId, String deviceId, Device device, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.tenantExists(tenantId, span)).compose(deviceDto -> this.processUpdateDevice(tenantId, deviceId, device.getStatus() != null ? device.getStatus().getAutoProvisioningNotificationSentSetInternal() : null, device, resourceVersion, span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<Result<Void>> deleteDevice(String tenantId, String deviceId, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.tenantExists(tenantId, span)).compose(ok -> this.processDeleteDevice(tenantId, deviceId, resourceVersion, span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    protected Future<RegistrationResult> getRegistrationInformation(DeviceKey deviceKey, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(span);
        return this.findDeviceDocument(deviceKey.getTenantId(), deviceKey.getDeviceId()).map(result -> Optional.ofNullable(result).map(ok -> this.getRegistrationResult(deviceKey.getDeviceId(), result.getJsonObject("device"))).orElseGet(() -> RegistrationResult.from((int)404)));
    }

    private Future<MongoDbBasedDeviceDto> findDevice(String tenantId, String deviceId) {
        return this.findDeviceDocument(tenantId, deviceId).compose(result -> Optional.ofNullable(result).map(ok -> MongoDbBasedDeviceDto.forRead(tenantId, deviceId, result)).map(Future::succeededFuture).orElseGet(() -> Future.failedFuture((Throwable)new ClientErrorException(404))));
    }

    private Future<JsonObject> findDeviceDocument(String tenantId, String deviceId) {
        JsonObject findDeviceQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withDeviceId(deviceId).document();
        Promise readDevicePromise = Promise.promise();
        this.mongoClient.findOne(this.config.getCollectionName(), findDeviceQuery, null, (Handler)readDevicePromise);
        return readDevicePromise.future();
    }

    private RegistrationResult getRegistrationResult(String deviceId, JsonObject devicePayload) {
        return RegistrationResult.from((int)200, (JsonObject)Optional.ofNullable(devicePayload).map(ok -> new JsonObject().put("device-id", deviceId).put("data", devicePayload)).orElse(null));
    }

    private Future<OperationResult<Id>> processCreateDevice(DeviceDto device, Span span) {
        TracingHelper.TAG_DEVICE_ID.set(span, device.getDeviceId());
        Promise addDevicePromise = Promise.promise();
        this.mongoClient.insert(this.config.getCollectionName(), JsonObject.mapFrom((Object)device), (Handler)addDevicePromise);
        return addDevicePromise.future().map(success -> {
            span.log("successfully registered device");
            return OperationResult.ok((int)201, (Object)Id.of((String)device.getDeviceId()), Optional.empty(), Optional.of(device.getVersion()));
        }).recover(error -> {
            if (MongoDbDeviceRegistryUtils.isDuplicateKeyError(error)) {
                LOG.debug("device [{}] already exists for tenant [{}]", new Object[]{device.getDeviceId(), device.getTenantId(), error});
                TracingHelper.logError((Span)span, (String)"device already exists");
                return Future.succeededFuture((Object)OperationResult.empty((int)409));
            }
            LOG.error("error adding device [{}] for tenant [{}]", new Object[]{device.getDeviceId(), device.getTenantId(), error});
            TracingHelper.logError((Span)span, (String)"error adding device", (Throwable)error);
            return Future.succeededFuture((Object)OperationResult.empty((int)500));
        });
    }

    private Future<Result<Void>> processDeleteDevice(String tenantId, String deviceId, Optional<String> resourceVersion, Span span) {
        JsonObject deleteDeviceQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).withDeviceId(deviceId).document();
        Promise deleteDevicePromise = Promise.promise();
        this.mongoClient.findOneAndDelete(this.config.getCollectionName(), deleteDeviceQuery, (Handler)deleteDevicePromise);
        return deleteDevicePromise.future().compose(result -> Optional.ofNullable(result).map(deleted -> {
            span.log("successfully deleted device");
            return Future.succeededFuture((Object)Result.from((int)204));
        }).orElseGet(() -> MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(deviceId, resourceVersion, this.findDevice(tenantId, deviceId))));
    }

    private Future<OperationResult<Device>> processReadDevice(String tenantId, String deviceId) {
        return this.findDevice(tenantId, deviceId).compose(deviceDto -> Future.succeededFuture((Object)OperationResult.ok((int)200, (Object)deviceDto.getDeviceWithStatus(), Optional.ofNullable(DeviceRegistryUtils.getCacheDirective((int)this.config.getCacheMaxAge())), Optional.ofNullable(deviceDto.getVersion()))));
    }

    protected Future<Set<String>> processResolveGroupMembers(String tenantId, Set<String> viaGroups, Span span) {
        JsonObject resolveGroupMembersQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).document().put(PROPERTY_DEVICE_MEMBER_OF, new JsonObject().put("$exists", Boolean.valueOf(true)).put("$in", new JsonArray(new ArrayList<String>(viaGroups))));
        FindOptions findOptionsForDeviceId = new FindOptions().setFields(new JsonObject().put("device-id", Boolean.valueOf(true)).put("_id", Boolean.valueOf(false)));
        Promise resolveGroupMembersPromise = Promise.promise();
        this.mongoClient.findWithOptions(this.config.getCollectionName(), resolveGroupMembersQuery, findOptionsForDeviceId, (Handler)resolveGroupMembersPromise);
        return resolveGroupMembersPromise.future().map(deviceIdsList -> {
            Set deviceIds = Optional.ofNullable(deviceIdsList).map(ok -> deviceIdsList.stream().map(json -> json.getString("device-id")).collect(Collectors.toSet())).orElse(Collections.emptySet());
            span.log("successfully resolved group members");
            return deviceIds;
        });
    }

    private static List<DeviceWithId> getDevicesWithId(JsonObject searchDevicesResult) {
        return Optional.ofNullable(searchDevicesResult.getJsonArray("result")).map(devices -> devices.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(json -> (MongoDbBasedDeviceDto)((Object)((Object)((Object)json.mapTo(MongoDbBasedDeviceDto.class))))).map(deviceDto -> DeviceWithId.from((String)deviceDto.getDeviceId(), (Device)deviceDto.getData())).collect(Collectors.toList())).orElseGet(ArrayList::new);
    }

    private Future<OperationResult<Id>> processUpdateDevice(String tenantId, String deviceId, Boolean autoProvisioningNotificationSent, Device device, Optional<String> resourceVersion, Span span) {
        JsonObject updateDeviceQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).withDeviceId(deviceId).document();
        Promise updateDevicePromise = Promise.promise();
        DeviceDto deviceDto = DeviceDto.forUpdate(MongoDbBasedDeviceDto::new, (String)tenantId, (String)deviceId, (Boolean)autoProvisioningNotificationSent, (Device)device, (String)new Versioned((Object)device).getVersion());
        this.mongoClient.findOneAndUpdateWithOptions(this.config.getCollectionName(), updateDeviceQuery, MongoDbDocumentBuilder.builder().forUpdateOf(deviceDto).document(), new FindOptions(), new UpdateOptions().setReturningNewDocument(true), (Handler)updateDevicePromise);
        return updateDevicePromise.future().compose(result -> Optional.ofNullable(result).map(updated -> {
            span.log("successfully updated device");
            return Future.succeededFuture((Object)OperationResult.ok((int)204, (Object)Id.of((String)deviceId), Optional.empty(), Optional.of(result.getString("version"))));
        }).orElseGet(() -> MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(deviceId, resourceVersion, this.findDevice(tenantId, deviceId))));
    }

    private <T> Future<T> isMaxDevicesLimitReached(String tenantId) {
        if (this.config.getMaxDevicesPerTenant() == -1) {
            return Future.succeededFuture();
        }
        Promise findExistingNoOfDevicesPromise = Promise.promise();
        this.mongoClient.count(this.config.getCollectionName(), MongoDbDocumentBuilder.builder().withTenantId(tenantId).document(), (Handler)findExistingNoOfDevicesPromise);
        return findExistingNoOfDevicesPromise.future().compose(existingNoOfDevices -> {
            if (existingNoOfDevices >= (long)this.config.getMaxDevicesPerTenant()) {
                return Future.failedFuture((Throwable)new ClientErrorException(403, String.format("Maximum number of devices limit already reached for the tenant [%s]", tenantId)));
            }
            return Future.succeededFuture();
        });
    }

    private Future<Void> tenantExists(String tenantId, Span span) {
        return this.tenantInformationService.tenantExists(tenantId, span).compose(result -> result.isOk() ? Future.succeededFuture() : Future.failedFuture((Throwable)StatusCodeMapper.from((int)result.getStatus(), null)));
    }
}

