/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.UpdateOptions;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.CredentialsDto;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbCallExecutor;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDocumentBuilder;
import org.eclipse.hono.deviceregistry.service.credentials.AbstractCredentialsManagementService;
import org.eclipse.hono.deviceregistry.service.device.DeviceKey;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.CredentialsResult;
import org.eclipse.hono.util.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedCredentialsService
extends AbstractCredentialsManagementService
implements CredentialsService,
Lifecycle,
HealthCheckProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedCredentialsService.class);
    private static final String CREDENTIALS_FILTERED_POSITIONAL_OPERATOR = String.format("%s.$", "credentials");
    private static final String KEY_AUTH_ID = String.format("%s.%s", "credentials", "auth-id");
    private static final String KEY_CREDENTIALS_TYPE = String.format("%s.%s", "credentials", "type");
    private final MongoDbBasedCredentialsConfigProperties config;
    private final MongoClient mongoClient;
    private final MongoDbCallExecutor mongoDbCallExecutor;
    private final AtomicBoolean creatingIndices = new AtomicBoolean(false);
    private final AtomicBoolean indicesCreated = new AtomicBoolean(false);

    public MongoDbBasedCredentialsService(Vertx vertx, MongoClient mongoClient, MongoDbBasedCredentialsConfigProperties config, HonoPasswordEncoder passwordEncoder) {
        super(Objects.requireNonNull(vertx), Objects.requireNonNull(passwordEncoder), config.getMaxBcryptCostFactor(), config.getHashAlgorithmsWhitelist());
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(config);
        this.mongoClient = mongoClient;
        this.config = config;
        this.mongoDbCallExecutor = new MongoDbCallExecutor(vertx, mongoClient);
    }

    Future<Void> createIndices() {
        if (this.creatingIndices.compareAndSet(false, true)) {
            return this.mongoDbCallExecutor.createIndex(this.config.getCollectionName(), new JsonObject().put("tenant-id", Integer.valueOf(1)).put("device-id", Integer.valueOf(1)), new IndexOptions().unique(true)).compose(ok -> this.mongoDbCallExecutor.createIndex(this.config.getCollectionName(), new JsonObject().put("tenant-id", Integer.valueOf(1)).put(KEY_AUTH_ID, Integer.valueOf(1)).put(KEY_CREDENTIALS_TYPE, Integer.valueOf(1)), new IndexOptions().unique(true).partialFilterExpression(new JsonObject().put(KEY_AUTH_ID, new JsonObject().put("$exists", Boolean.valueOf(true))).put(KEY_CREDENTIALS_TYPE, new JsonObject().put("$exists", Boolean.valueOf(true)))))).onSuccess(ok -> this.indicesCreated.set(true)).onComplete(r -> this.creatingIndices.set(false));
        }
        return Future.failedFuture((Throwable)new ConcurrentModificationException("already trying to create indices"));
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register("credentials-indices-created-" + UUID.randomUUID(), status -> {
            if (this.indicesCreated.get()) {
                status.complete((Object)Status.OK());
            } else {
                LOG.debug("credentials-indices not (yet) created");
                status.complete((Object)Status.KO());
                this.createIndices();
            }
        });
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    public Future<Void> start() {
        this.createIndices();
        LOG.info("MongoDB Credentials service started");
        return Future.succeededFuture();
    }

    public Future<Void> stop() {
        this.mongoClient.close();
        return Future.succeededFuture();
    }

    public Future<CredentialsResult<JsonObject>> get(String tenantId, String type, String authId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(type);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(span);
        return this.processGetCredential(tenantId, type, authId, null);
    }

    public Future<CredentialsResult<JsonObject>> get(String tenantId, String type, String authId, JsonObject clientContext, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(type);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(clientContext);
        Objects.requireNonNull(span);
        return this.processGetCredential(tenantId, type, authId, clientContext);
    }

    protected Future<OperationResult<Void>> processUpdateCredentials(DeviceKey deviceKey, Optional<String> resourceVersion, List<CommonCredential> updatedCredentials, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceKey.getDeviceId());
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> {
            CredentialsDto updatedCredentialsDto = CredentialsDto.forUpdate(deviceKey.getTenantId(), deviceKey.getDeviceId(), updatedCredentials, DeviceRegistryUtils.getUniqueIdentifier());
            if (updatedCredentialsDto.requiresMerging()) {
                return this.getCredentialsDto(deviceKey, resourceVersion).map(updatedCredentialsDto::merge);
            }
            return Future.succeededFuture((Object)((Object)updatedCredentialsDto));
        }).compose(credentialsDto -> {
            credentialsDto.createMissingSecretIds();
            return this.updateCredentials(deviceKey, resourceVersion, JsonObject.mapFrom((Object)credentialsDto), span);
        }).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    protected Future<OperationResult<List<CommonCredential>>> processReadCredentials(DeviceKey deviceKey, Span span) {
        Objects.requireNonNull(deviceKey);
        Objects.requireNonNull(span);
        return this.getCredentialsDto(deviceKey).map(credentialsDto -> OperationResult.ok((int)200, credentialsDto.getCredentials(), Optional.empty(), Optional.of(credentialsDto.getVersion()))).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<Result<Void>> addCredentials(String tenantId, String deviceId, List<CommonCredential> credentials, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(credentials);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
        return this.processAddCredentials(tenantId, deviceId, credentials, resourceVersion, span).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    public Future<Result<Void>> removeCredentials(String tenantId, String deviceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
        return this.processRemoveCredentials(tenantId, deviceId, span).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    private Future<CredentialsDto> getCredentialsDto(DeviceKey deviceKey) {
        return this.getCredentialsDto(deviceKey, Optional.empty());
    }

    private Future<CredentialsDto> getCredentialsDto(DeviceKey deviceKey, Optional<String> resourceVersion) {
        JsonObject findCredentialsQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(deviceKey.getTenantId()).withDeviceId(deviceKey.getDeviceId()).document();
        Promise findCredentialsPromise = Promise.promise();
        this.mongoClient.findOne(this.config.getCollectionName(), findCredentialsQuery, null, (Handler)findCredentialsPromise);
        return findCredentialsPromise.future().compose(result -> Optional.ofNullable(result).map(credentialsDtoJson -> (CredentialsDto)((Object)((Object)((Object)credentialsDtoJson.mapTo(CredentialsDto.class))))).map(Future::succeededFuture).orElseGet(() -> MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(deviceKey.getDeviceId(), resourceVersion, this.getCredentialsDto(deviceKey))));
    }

    private Future<CredentialsResult<JsonObject>> getCredentialsResult(String tenantId, String authId, String type, JsonObject clientContext) {
        JsonObject findCredentialsQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withAuthId(authId).withType(type).document();
        Promise findCredentialsPromise = Promise.promise();
        if (LOG.isTraceEnabled()) {
            LOG.trace("retrieving credentials using search criteria: {}", (Object)findCredentialsQuery.encodePrettily());
        }
        this.mongoClient.findOne(this.config.getCollectionName(), findCredentialsQuery, new JsonObject().put("device-id", Integer.valueOf(1)).put(CREDENTIALS_FILTERED_POSITIONAL_OPERATOR, Integer.valueOf(1)).put("_id", Integer.valueOf(0)), (Handler)findCredentialsPromise);
        return findCredentialsPromise.future().map(result -> Optional.ofNullable(result).flatMap(json -> Optional.ofNullable(json.getJsonArray("credentials"))).map(credential -> credential.getJsonObject(0)).filter(this::isCredentialEnabled).filter(credential -> DeviceRegistryUtils.matchesWithClientContext((JsonObject)credential, (JsonObject)clientContext)).map(credential -> credential.put("device-id", result.getString("device-id"))).map(credential -> CredentialsResult.from((int)200, (Object)credential, (CacheDirective)this.getCacheDirective(type))).orElseGet(() -> CredentialsResult.from((int)404)));
    }

    private CacheDirective getCacheDirective(String type) {
        if (this.config.getCacheMaxAge() > 0) {
            switch (type) {
                case "hashed-password": 
                case "x509-cert": {
                    return CacheDirective.maxAgeDirective((long)this.config.getCacheMaxAge());
                }
            }
            return CacheDirective.noCacheDirective();
        }
        return CacheDirective.noCacheDirective();
    }

    private boolean isCredentialEnabled(JsonObject credential) {
        return Optional.ofNullable(credential.getBoolean("enabled")).orElse(true);
    }

    private Future<CredentialsResult<JsonObject>> processGetCredential(String tenantId, String type, String authId, JsonObject clientContext) {
        return this.getCredentialsResult(tenantId, authId, type, clientContext);
    }

    private Future<Result<Void>> processAddCredentials(String tenantId, String deviceId, List<CommonCredential> credentials, Optional<String> resourceVersion, Span span) {
        Promise addCredentialsPromise = Promise.promise();
        CredentialsDto credentialsDto = CredentialsDto.forCreation(tenantId, deviceId, credentials, resourceVersion.orElseGet(DeviceRegistryUtils::getUniqueIdentifier));
        this.mongoClient.insert(this.config.getCollectionName(), JsonObject.mapFrom((Object)((Object)credentialsDto)), (Handler)addCredentialsPromise);
        return addCredentialsPromise.future().map(added -> {
            span.log("successfully added credentials");
            LOG.debug("successfully added credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            return Result.from((int)204);
        });
    }

    private Future<Result<Void>> processRemoveCredentials(String tenantId, String deviceId, Span span) {
        JsonObject removeCredentialsQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).withDeviceId(deviceId).document();
        Promise removeCredentialsPromise = Promise.promise();
        this.mongoClient.findOneAndDelete(this.config.getCollectionName(), removeCredentialsQuery, (Handler)removeCredentialsPromise);
        return removeCredentialsPromise.future().compose(result -> Optional.ofNullable(result).map(removed -> {
            span.log("successfully removed credentials");
            LOG.debug("successfully removed credentials for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
            return Future.succeededFuture((Object)Result.from((int)204));
        }).orElseGet(() -> Future.failedFuture((Throwable)new ClientErrorException(404))));
    }

    private Future<OperationResult<Void>> updateCredentials(DeviceKey deviceKey, Optional<String> resourceVersion, JsonObject credentialsDtoJson, Span span) {
        JsonObject replaceCredentialsQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(deviceKey.getTenantId()).withDeviceId(deviceKey.getDeviceId()).document();
        Promise replaceCredentialsPromise = Promise.promise();
        if (LOG.isTraceEnabled()) {
            LOG.trace("updating credentials of device [tenant: {}, device-id: {}]: {}{}", new Object[]{deviceKey.getTenantId(), deviceKey.getDeviceId(), System.lineSeparator(), credentialsDtoJson.encodePrettily()});
        }
        this.mongoClient.findOneAndReplaceWithOptions(this.config.getCollectionName(), replaceCredentialsQuery, credentialsDtoJson, new FindOptions(), new UpdateOptions().setReturningNewDocument(true), (Handler)replaceCredentialsPromise);
        return replaceCredentialsPromise.future().compose(result -> {
            if (result == null) {
                return MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(deviceKey.getDeviceId(), resourceVersion, this.getCredentialsDto(deviceKey));
            }
            LOG.debug("successfully updated credentials for device [tenant: {}, device-id: {}}]", (Object)deviceKey.getTenantId(), (Object)deviceKey.getDeviceId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("new document in DB: {}{}", (Object)System.lineSeparator(), (Object)result.encodePrettily());
            }
            span.log("successfully updated credentials");
            return Future.succeededFuture((Object)OperationResult.ok((int)204, (Object)null, Optional.empty(), Optional.of(result.getString("version"))));
        }).recover(error -> {
            if (MongoDbDeviceRegistryUtils.isDuplicateKeyError(error)) {
                LOG.debug("credentials (type, auth-id) must be unique for device [tenant: {}, device-id: {}]", new Object[]{deviceKey.getTenantId(), deviceKey.getTenantId(), error});
                TracingHelper.logError((Span)span, (String)"credentials (type, auth-id) must be unique for device");
                return Future.succeededFuture((Object)OperationResult.empty((int)409));
            }
            return Future.failedFuture((Throwable)error);
        });
    }
}

