/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceDto;
import org.eclipse.hono.service.management.device.DeviceStatus;

public final class MongoDbBasedDeviceDto
extends DeviceDto {
    public static MongoDbBasedDeviceDto forRead(String tenantId, String deviceId, JsonObject recordJson) {
        return (MongoDbBasedDeviceDto)DeviceDto.forRead(MongoDbBasedDeviceDto::new, (String)tenantId, (String)deviceId, (Device)((Device)recordJson.getJsonObject("device").mapTo(Device.class)), (DeviceStatus)new DeviceStatus().setAutoProvisioned(recordJson.getBoolean("autoProvisioned")).setAutoProvisioningNotificationSent(recordJson.getBoolean("autoProvisioningNotificationSent")), (Instant)recordJson.getInstant("created"), (Instant)recordJson.getInstant("updatedOn"), (String)recordJson.getString("version"));
    }

    @JsonProperty(value="auto-provisioned")
    public boolean isAutoProvisioned() {
        return this.getDeviceStatus().isAutoProvisioned();
    }

    @JsonProperty(value="auto-provisioning-notification-sent")
    public boolean isAutoProvisioningNotificationSent() {
        return this.getDeviceStatus().isAutoProvisioningNotificationSent();
    }

    @JsonProperty(value="device")
    public Device getData() {
        return (Device)super.getData();
    }
}

