/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import java.util.Objects;
import org.eclipse.hono.deviceregistry.mongodb.ApplicationConfig;
import org.eclipse.hono.service.AbstractApplication;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Import;

@ComponentScans(value={@ComponentScan(basePackages={"org.eclipse.hono.service.auth"}, excludeFilters={@ComponentScan.Filter(value={Deprecated.class})}), @ComponentScan(basePackages={"org.eclipse.hono.service.metric"}, excludeFilters={@ComponentScan.Filter(value={Deprecated.class})})})
@Import(value={ApplicationConfig.class})
@EnableAutoConfiguration
public class Application
extends AbstractApplication {
    private AuthenticationService authService;

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Autowired
    public void setAuthenticationService(AuthenticationService service) {
        Objects.requireNonNull(service);
        if (!(service instanceof Verticle)) {
            throw new IllegalArgumentException("authentication service must be a vert.x Verticle");
        }
        this.authService = service;
    }

    protected Future<?> deployRequiredVerticles(int maxInstances) {
        return this.deployVerticle(this.authService).onSuccess(id -> this.registerHealthCheckProvider(this.authService));
    }

    protected void postDeploy(AbstractServiceBase<?> serviceInstance) {
        this.registerHealthCheckProvider(serviceInstance);
    }

    private void registerHealthCheckProvider(Object obj) {
        if (obj instanceof HealthCheckProvider) {
            this.registerHealthchecks((HealthCheckProvider)obj);
        }
    }

    private Future<String> deployVerticle(Object component) {
        Promise result = Promise.promise();
        if (component instanceof Verticle) {
            this.log.info("deploying component [{}]", (Object)component.getClass().getName());
            this.getVertx().deployVerticle((Verticle)component, (Handler)result);
        } else {
            result.fail(String.format("cannot deploy component [%s]: not a Verticle", component.getClass().getName()));
        }
        return result.future();
    }
}

