/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hono.deviceregistry.mongodb.config.AbstractMongoDbBasedRegistryConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedCredentialsConfigProperties
extends AbstractMongoDbBasedRegistryConfigProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedCredentialsConfigProperties.class);
    private static final String DEFAULT_CREDENTIALS_COLLECTION_NAME = "credentials";
    private final Set<String> hashAlgorithmsWhitelist = new HashSet<String>();
    private int maxBcryptCostFactor = 10;

    @Override
    protected String getDefaultCollectionName() {
        return DEFAULT_CREDENTIALS_COLLECTION_NAME;
    }

    public int getMaxBcryptCostFactor() {
        return this.maxBcryptCostFactor;
    }

    @Deprecated(forRemoval=true)
    public int getMaxBcryptIterations() {
        return this.getMaxBcryptCostFactor();
    }

    public void setMaxBcryptCostFactor(int costFactor) {
        if (costFactor < 4 || costFactor > 31) {
            throw new IllegalArgumentException("iterations must be > 3 and < 32");
        }
        this.maxBcryptCostFactor = costFactor;
    }

    @Deprecated(forRemoval=true)
    public void setMaxBcryptIterations(int costFactor) {
        LOG.warn("the maxBcryptIterations property is deprecated, please update your configuration to use maxBcryptCostFactor instead");
        this.setMaxBcryptCostFactor(costFactor);
    }

    public Set<String> getHashAlgorithmsWhitelist() {
        return Collections.unmodifiableSet(this.hashAlgorithmsWhitelist);
    }

    public void setHashAlgorithmsWhitelist(String[] hashAlgorithmsWhitelist) {
        Objects.requireNonNull(hashAlgorithmsWhitelist);
        this.hashAlgorithmsWhitelist.clear();
        this.hashAlgorithmsWhitelist.addAll(Arrays.asList(hashAlgorithmsWhitelist));
    }
}

