/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.service.management.BaseDto;
import org.eclipse.hono.service.management.device.DeviceDto;
import org.eclipse.hono.service.management.device.Filter;
import org.eclipse.hono.service.management.device.Sort;

public final class MongoDbDocumentBuilder {
    public static final String SET_OPERATOR = "$set";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonPointer FIELD_ID = JsonPointer.from((String)"/id");
    private static final String FIELD_CREDENTIALS_AUTH_ID_KEY = String.format("%s.%s", "credentials", "auth-id");
    private static final String FIELD_CREDENTIALS_TYPE_KEY = String.format("%s.%s", "credentials", "type");
    private static final String TENANT_TRUSTED_CA_SUBJECT_PATH = String.format("%s.%s.%s", "tenant", "trusted-ca", "subject-dn");
    private final JsonObject document = new JsonObject();

    private MongoDbDocumentBuilder() {
    }

    public static MongoDbDocumentBuilder builder() {
        return new MongoDbDocumentBuilder();
    }

    public MongoDbDocumentBuilder forUpdateOf(DeviceDto deviceDto) {
        this.forUpdateOf((BaseDto<?>)deviceDto);
        JsonObject updateDocument = this.document.getJsonObject(SET_OPERATOR);
        updateDocument.put("autoProvisioned", Boolean.valueOf(deviceDto.getDeviceStatus().isAutoProvisioned()));
        updateDocument.put("autoProvisioningNotificationSent", Boolean.valueOf(deviceDto.getDeviceStatus().isAutoProvisioningNotificationSent()));
        return this;
    }

    public MongoDbDocumentBuilder forUpdateOf(BaseDto<?> baseDto) {
        JsonObject updates = new JsonObject();
        if (baseDto.getData() != null) {
            JavaType baseDtoJavaType = OBJECT_MAPPER.getTypeFactory().constructType(baseDto.getClass());
            BeanDescription beanDescription = OBJECT_MAPPER.getSerializationConfig().introspect(baseDtoJavaType);
            AnnotatedMethod getDataMethod = beanDescription.findMethod("getData", null);
            JsonProperty jsonProperty = (JsonProperty)getDataMethod.getAnnotation(JsonProperty.class);
            updates.put(jsonProperty.value(), JsonObject.mapFrom((Object)baseDto.getData()));
        }
        if (baseDto.getCreationTime() != null) {
            updates.put("created", baseDto.getCreationTime());
        }
        if (baseDto.getUpdatedOn() != null) {
            updates.put("updatedOn", baseDto.getUpdatedOn());
        }
        if (baseDto.getVersion() != null) {
            updates.put("version", baseDto.getVersion());
        }
        this.document.put(SET_OPERATOR, updates);
        return this;
    }

    public MongoDbDocumentBuilder withTenantId(String tenantId) {
        this.document.put("tenant-id", tenantId);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceId(String deviceId) {
        this.document.put("device-id", deviceId);
        return this;
    }

    public MongoDbDocumentBuilder withCa(String subjectDn) {
        this.document.put(TENANT_TRUSTED_CA_SUBJECT_PATH, new JsonObject().put("$eq", subjectDn));
        return this;
    }

    public MongoDbDocumentBuilder withVersion(Optional<String> version) {
        Objects.requireNonNull(version);
        version.ifPresent(ver -> this.document.put("version", ver));
        return this;
    }

    public JsonObject document() {
        return this.document;
    }

    public MongoDbDocumentBuilder withType(String type) {
        this.document.put(FIELD_CREDENTIALS_TYPE_KEY, type);
        return this;
    }

    public MongoDbDocumentBuilder withAuthId(String authId) {
        this.document.put(FIELD_CREDENTIALS_AUTH_ID_KEY, authId);
        return this;
    }

    public MongoDbDocumentBuilder withDeviceFilters(List<Filter> filters) {
        filters.forEach(filter -> {
            if (filter.getValue() instanceof String) {
                String value = (String)filter.getValue();
                this.document.put(MongoDbDocumentBuilder.mapDeviceField(filter.getField()), new JsonObject().put("$regex", DeviceRegistryUtils.getRegexExpressionForSearchOperation((String)value)));
            } else {
                this.document.put(MongoDbDocumentBuilder.mapDeviceField(filter.getField()), filter.getValue());
            }
        });
        return this;
    }

    public MongoDbDocumentBuilder withDeviceSortOptions(List<Sort> sortOptions) {
        sortOptions.forEach(sortOption -> this.document.put(MongoDbDocumentBuilder.mapDeviceField(sortOption.getField()), Integer.valueOf(MongoDbDocumentBuilder.mapSortingDirection(sortOption.getDirection()))));
        return this;
    }

    private static String mapDeviceField(JsonPointer field) {
        if (FIELD_ID.equals(field)) {
            return "device-id";
        }
        return "device" + field.toString().replace("/", ".");
    }

    private static int mapSortingDirection(Sort.Direction direction) {
        if (direction == Sort.Direction.asc) {
            return 1;
        }
        return -1;
    }
}

