/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.utils;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbCallExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbCallExecutor.class);
    private static final int INDEX_CREATION_RETRY_INTERVAL_IN_MS = 3000;
    private final MongoClient mongoClient;
    private final Vertx vertx;

    public MongoDbCallExecutor(Vertx vertx, MongoClient mongoClient) {
        this.vertx = Objects.requireNonNull(vertx);
        this.mongoClient = Objects.requireNonNull(mongoClient);
    }

    public Future<Void> createCollectionIndex(String collectionName, JsonObject keys, IndexOptions options, int noOfRetries) {
        Promise indexCreationPromise = Promise.promise();
        LOG.info("creating index [collection: {}]", (Object)collectionName);
        this.mongoClient.createIndexWithOptions(collectionName, keys, options, res -> {
            if (res.succeeded()) {
                LOG.info("successfully created index [collection: {}]", (Object)collectionName);
                indexCreationPromise.complete();
            } else if (noOfRetries > 0) {
                LOG.error("failed to create index [collection: {}], scheduling new attempt to create index", (Object)collectionName, (Object)res.cause());
                this.vertx.setTimer(3000L, id -> this.createCollectionIndex(collectionName, keys, options, noOfRetries - 1));
            } else {
                LOG.error("failed to create index [collection: {}]", (Object)collectionName, (Object)res.cause());
                indexCreationPromise.fail(res.cause());
            }
        });
        return indexCreationPromise.future();
    }
}

