/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb.service;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.UpdateOptions;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.model.TenantDto;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbCallExecutor;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.mongodb.utils.MongoDbDocumentBuilder;
import org.eclipse.hono.deviceregistry.util.DeviceRegistryUtils;
import org.eclipse.hono.deviceregistry.util.Versioned;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.service.management.tenant.TenantManagementService;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.TenantResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDbBasedTenantService
implements TenantService,
TenantManagementService,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasedTenantService.class);
    private static final int INDEX_CREATION_MAX_RETRIES = 3;
    private final MongoClient mongoClient;
    private final MongoDbCallExecutor mongoDbCallExecutor;
    private final MongoDbBasedTenantsConfigProperties config;

    public MongoDbBasedTenantService(Vertx vertx, MongoClient mongoClient, MongoDbBasedTenantsConfigProperties config) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(mongoClient);
        Objects.requireNonNull(config);
        this.mongoClient = mongoClient;
        this.mongoDbCallExecutor = new MongoDbCallExecutor(vertx, mongoClient);
        this.config = Objects.requireNonNull(config);
    }

    public Future<Void> start() {
        return this.mongoDbCallExecutor.createCollectionIndex(this.config.getCollectionName(), new JsonObject().put("tenant-id", Integer.valueOf(1)), new IndexOptions().unique(true), 3).compose(ok -> this.mongoDbCallExecutor.createCollectionIndex(this.config.getCollectionName(), new JsonObject().put("tenant.trusted-ca.subject-dn", Integer.valueOf(1)), new IndexOptions().unique(true).partialFilterExpression(new JsonObject().put("tenant.trusted-ca", new JsonObject().put("$exists", Boolean.valueOf(true)))), 3)).onSuccess(ok -> LOG.info("MongoDB Tenant service started"));
    }

    public Future<Void> stop() {
        this.mongoClient.close();
        return Future.succeededFuture();
    }

    public Future<OperationResult<Void>> updateTenant(String tenantId, Tenant tenantObj, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(tenantObj);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.processUpdateTenant(tenantId, tenantObj, resourceVersion, span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    private Future<OperationResult<Void>> processUpdateTenant(String tenantId, Tenant newTenant, Optional<String> resourceVersion, Span span) {
        JsonObject updateTenantQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).document();
        Promise updateTenantPromise = Promise.promise();
        TenantDto newTenantDto = TenantDto.forUpdate(tenantId, newTenant, new Versioned((Object)newTenant).getVersion());
        this.mongoClient.findOneAndReplaceWithOptions(this.config.getCollectionName(), updateTenantQuery, JsonObject.mapFrom((Object)((Object)newTenantDto)), new FindOptions(), new UpdateOptions().setReturningNewDocument(true), (Handler)updateTenantPromise);
        return updateTenantPromise.future().compose(updateResult -> Optional.ofNullable(updateResult).map(updated -> {
            span.log("successfully updated tenant");
            return Future.succeededFuture((Object)OperationResult.ok((int)204, (Object)null, Optional.empty(), Optional.of(updateResult.getString("version"))));
        }).orElseGet(() -> MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(tenantId, resourceVersion, this.findTenant(tenantId)))).recover(error -> {
            if (MongoDbDeviceRegistryUtils.isDuplicateKeyError(error)) {
                LOG.debug("conflict updating tenant [{}]. An existing tenant uses a certificate authority with the same Subject DN", (Object)tenantId, error);
                TracingHelper.logError((Span)span, (String)"an existing tenant uses a certificate authority with the same Subject DN", (Throwable)error);
                return Future.succeededFuture((Object)OperationResult.empty((int)409));
            }
            return Future.failedFuture((Throwable)error);
        });
    }

    public Future<Result<Void>> deleteTenant(String tenantId, Optional<String> resourceVersion, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(resourceVersion);
        Objects.requireNonNull(span);
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.processDeleteTenant(tenantId, resourceVersion, span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    private Future<Result<Void>> processDeleteTenant(String tenantId, Optional<String> resourceVersion, Span span) {
        JsonObject deleteTenantQuery = MongoDbDocumentBuilder.builder().withVersion(resourceVersion).withTenantId(tenantId).document();
        Promise deleteTenantPromise = Promise.promise();
        this.mongoClient.findOneAndDelete(this.config.getCollectionName(), deleteTenantQuery, (Handler)deleteTenantPromise);
        return deleteTenantPromise.future().compose(tenantDtoResult -> Optional.ofNullable(tenantDtoResult).map(deleted -> {
            span.log("successfully deleted tenant");
            return Future.succeededFuture((Object)Result.from((int)204));
        }).orElseGet(() -> MongoDbDeviceRegistryUtils.checkForVersionMismatchAndFail(tenantId, resourceVersion, this.findTenant(tenantId))));
    }

    public Future<TenantResult<JsonObject>> get(String tenantId) {
        return this.get(tenantId, (Span)NoopSpan.INSTANCE);
    }

    public Future<TenantResult<JsonObject>> get(String tenantId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(span);
        return this.readTenant(tenantId, span).compose(tenantDtoResult -> {
            if (tenantDtoResult.getStatus() != 200) {
                TracingHelper.logError((Span)span, (String)"tenant not found");
                return Future.succeededFuture((Object)TenantResult.from((int)404));
            }
            return Future.succeededFuture((Object)TenantResult.from((int)200, (Object)DeviceRegistryUtils.convertTenant((String)tenantId, (Tenant)((Tenant)tenantDtoResult.getPayload()), (boolean)true), (CacheDirective)DeviceRegistryUtils.getCacheDirective((int)this.config.getCacheMaxAge())));
        });
    }

    public Future<TenantResult<JsonObject>> get(X500Principal subjectDn) {
        return this.get(subjectDn, (Span)NoopSpan.INSTANCE);
    }

    public Future<TenantResult<JsonObject>> get(X500Principal subjectDn, Span span) {
        Objects.requireNonNull(subjectDn);
        Objects.requireNonNull(span);
        return this.findTenant(subjectDn).compose(tenantDtoResult -> Future.succeededFuture((Object)TenantResult.from((int)200, (Object)DeviceRegistryUtils.convertTenant((String)tenantDtoResult.getTenantId(), (Tenant)tenantDtoResult.getData(), (boolean)true), (CacheDirective)DeviceRegistryUtils.getCacheDirective((int)this.config.getCacheMaxAge())))).recover(error -> {
            TracingHelper.logError((Span)span, (String)"no tenant found for subject DN", (Throwable)error);
            return Future.succeededFuture((Object)TenantResult.from((int)404));
        });
    }

    public Future<OperationResult<Tenant>> readTenant(String tenantId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(span);
        return this.processReadTenant(tenantId).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    private Future<OperationResult<Tenant>> processReadTenant(String tenantId) {
        return this.findTenant(tenantId).compose(tenantDtoResult -> Future.succeededFuture((Object)OperationResult.ok((int)200, (Object)tenantDtoResult.getData(), Optional.ofNullable(DeviceRegistryUtils.getCacheDirective((int)this.config.getCacheMaxAge())), Optional.ofNullable(tenantDtoResult.getVersion()))));
    }

    private Future<TenantDto> findTenant(String tenantId) {
        Objects.requireNonNull(tenantId);
        JsonObject findTenantQuery = MongoDbDocumentBuilder.builder().withTenantId(tenantId).document();
        return this.findTenant(findTenantQuery);
    }

    private Future<TenantDto> findTenant(X500Principal subjectDn) {
        Objects.requireNonNull(subjectDn);
        JsonObject findTenantQuery = MongoDbDocumentBuilder.builder().withCa(subjectDn.getName()).document();
        return this.findTenant(findTenantQuery);
    }

    private Future<TenantDto> findTenant(JsonObject findQuery) {
        Objects.requireNonNull(findQuery);
        Promise findTenantPromise = Promise.promise();
        this.mongoClient.findOne(this.config.getCollectionName(), findQuery, new JsonObject(), (Handler)findTenantPromise);
        return findTenantPromise.future().compose(tenantJsonResult -> Optional.ofNullable(tenantJsonResult).map(tenantJson -> Future.succeededFuture((Object)((Object)TenantDto.forRead(tenantJsonResult.getString("tenant-id"), (Tenant)tenantJsonResult.getJsonObject("tenant").mapTo(Tenant.class), tenantJsonResult.getInstant("created"), tenantJsonResult.getInstant("updatedOn"), tenantJsonResult.getString("version"))))).orElseGet(() -> Future.failedFuture((Throwable)new ClientErrorException(404))));
    }

    public Future<OperationResult<Id>> createTenant(Optional<String> tenantId, Tenant tenantObj, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(tenantObj);
        Objects.requireNonNull(span);
        String tenantIdOrGenerated = tenantId.orElseGet(() -> DeviceRegistryUtils.getUniqueIdentifier());
        return MongoDbDeviceRegistryUtils.isModificationEnabled(this.config).compose(ok -> this.processCreateTenant(tenantIdOrGenerated, tenantObj, span)).recover(error -> Future.succeededFuture(MongoDbDeviceRegistryUtils.mapErrorToResult(error, span)));
    }

    private Future<OperationResult<Id>> processCreateTenant(String tenantId, Tenant tenantObj, Span span) {
        TenantDto newTenantDto = TenantDto.forCreation(tenantId, tenantObj, new Versioned((Object)tenantObj).getVersion());
        TracingHelper.TAG_DEVICE_ID.set(span, tenantId);
        JsonObject newTenantDtoJson = JsonObject.mapFrom((Object)((Object)newTenantDto));
        Promise createTenantPromise = Promise.promise();
        this.mongoClient.insert(this.config.getCollectionName(), newTenantDtoJson, (Handler)createTenantPromise);
        return createTenantPromise.future().compose(tenantObjectIdResult -> {
            span.log("successfully created tenant");
            return Future.succeededFuture((Object)OperationResult.ok((int)201, (Object)Id.of((String)tenantId), Optional.empty(), Optional.of(newTenantDto.getVersion())));
        }).recover(error -> {
            if (MongoDbDeviceRegistryUtils.isDuplicateKeyError(error)) {
                LOG.debug("tenant [{}] already exists or an existing tenant uses a certificate authority with the same Subject DN", (Object)tenantId, error);
                TracingHelper.logError((Span)span, (String)"tenant with the given identifier already exists or an existing tenant uses a certificate authority with the same Subject DN", (Throwable)error);
                return Future.succeededFuture((Object)OperationResult.empty((int)409));
            }
            LOG.error("error adding tenant [{}]", (Object)tenantId, error);
            TracingHelper.logError((Span)span, (String)"error adding Tenant", (Throwable)error);
            return Future.succeededFuture((Object)OperationResult.empty((int)500));
        });
    }
}

