/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceregistry.mongodb;

import io.micrometer.core.instrument.MeterRegistry;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.mongo.MongoAuth;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.web.handler.AuthHandler;
import java.util.Optional;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.auth.SpringBasedHonoPasswordEncoder;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.config.VertxProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedCredentialsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedRegistrationConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbBasedTenantsConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.config.MongoDbConfigProperties;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedCredentialsService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedDeviceBackend;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedRegistrationService;
import org.eclipse.hono.deviceregistry.mongodb.service.MongoDbBasedTenantService;
import org.eclipse.hono.deviceregistry.server.DeviceRegistryAmqpServer;
import org.eclipse.hono.deviceregistry.server.DeviceRegistryHttpServer;
import org.eclipse.hono.deviceregistry.service.tenant.AutowiredTenantInformationService;
import org.eclipse.hono.deviceregistry.service.tenant.TenantInformationService;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.VertxBasedHealthCheckServer;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.service.credentials.DelegatingCredentialsAmqpEndpoint;
import org.eclipse.hono.service.http.HonoBasicAuthHandler;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.service.http.HttpServiceConfigProperties;
import org.eclipse.hono.service.management.credentials.CredentialsManagementService;
import org.eclipse.hono.service.management.credentials.DelegatingCredentialsManagementHttpEndpoint;
import org.eclipse.hono.service.management.device.DelegatingDeviceManagementHttpEndpoint;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.service.management.tenant.DelegatingTenantManagementHttpEndpoint;
import org.eclipse.hono.service.management.tenant.TenantManagementService;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.service.registration.DelegatingRegistrationAmqpEndpoint;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.service.tenant.DelegatingTenantAmqpEndpoint;
import org.eclipse.hono.service.tenant.TenantService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ObjectFactoryCreatingFactoryBean;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class ApplicationConfig {
    private static final String BEAN_NAME_AMQP_SERVER = "amqpServer";
    private static final String BEAN_NAME_HTTP_SERVER = "httpServer";

    @Bean
    public Vertx vertx() {
        return Vertx.vertx((VertxOptions)this.vertxProperties().configureVertx(new VertxOptions()));
    }

    @ConfigurationProperties(value="hono.vertx")
    @Bean
    public VertxProperties vertxProperties() {
        return new VertxProperties();
    }

    @Bean
    public Tracer getTracer() {
        return Optional.ofNullable(TracerResolver.resolveTracer()).orElse((Tracer)NoopTracerFactory.create());
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> commonTags() {
        return r -> r.config().commonTags((Iterable)MetricsTags.forService((String)"hono-registry"));
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.health-check")
    public ServerConfig healthCheckConfigProperties() {
        return new ServerConfig();
    }

    @Bean
    public HealthCheckServer healthCheckServer() {
        return new VertxBasedHealthCheckServer(this.vertx(), this.healthCheckConfigProperties());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.mongodb")
    public MongoDbConfigProperties mongoDbConfigProperties() {
        return new MongoDbConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public MongoClient mongoClient() {
        return MongoClient.createShared((Vertx)this.vertx(), (JsonObject)this.mongoDbConfigProperties().getMongoClientConfig());
    }

    @Bean
    public HonoPasswordEncoder passwordEncoder() {
        return new SpringBasedHonoPasswordEncoder(this.credentialsServiceProperties().getMaxBcryptCostFactor());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.registry.svc")
    public MongoDbBasedRegistrationConfigProperties registrationServiceProperties() {
        return new MongoDbBasedRegistrationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.tenant.svc")
    public MongoDbBasedTenantsConfigProperties tenantsServiceProperties() {
        return new MongoDbBasedTenantsConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.credentials.svc")
    public MongoDbBasedCredentialsConfigProperties credentialsServiceProperties() {
        return new MongoDbBasedCredentialsConfigProperties();
    }

    @Qualifier(value="amqp")
    @Bean
    @ConfigurationProperties(prefix="hono.registry.amqp")
    public ServiceConfigProperties amqpServerProperties() {
        return new ServiceConfigProperties();
    }

    @Bean(name={"amqpServer"})
    @Scope(value="prototype")
    public DeviceRegistryAmqpServer amqpServer() {
        return new DeviceRegistryAmqpServer();
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean amqpServerFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_AMQP_SERVER);
        return factory;
    }

    @Bean
    @Scope(value="prototype")
    public MongoDbBasedRegistrationService registrationService() {
        return new MongoDbBasedRegistrationService(this.vertx(), this.mongoClient(), this.registrationServiceProperties(), (TenantInformationService)this.tenantInformationService());
    }

    @Bean
    @Scope(value="prototype")
    public MongoDbBasedCredentialsService credentialsService() {
        return new MongoDbBasedCredentialsService(this.vertx(), this.mongoClient(), this.credentialsServiceProperties(), this.passwordEncoder());
    }

    @Bean
    @Scope(value="prototype")
    public MongoDbBasedTenantService tenantService() {
        return new MongoDbBasedTenantService(this.vertx(), this.mongoClient(), this.tenantsServiceProperties());
    }

    @Bean
    @Scope(value="prototype")
    public AutowiredTenantInformationService tenantInformationService() {
        return new AutowiredTenantInformationService();
    }

    @Bean
    @Scope(value="prototype")
    public AmqpEndpoint registrationAmqpEndpoint() {
        return new DelegatingRegistrationAmqpEndpoint(this.vertx(), (RegistrationService)this.registrationService());
    }

    @Bean
    @Scope(value="prototype")
    public AmqpEndpoint credentialsAmqpEndpoint() {
        MongoDbBasedDeviceBackend service = new MongoDbBasedDeviceBackend(this.registrationService(), this.credentialsService());
        return new DelegatingCredentialsAmqpEndpoint(this.vertx(), (CredentialsService)service);
    }

    @Bean
    @Scope(value="prototype")
    public AmqpEndpoint tenantAmqpEndpoint() {
        return new DelegatingTenantAmqpEndpoint(this.vertx(), (TenantService)this.tenantService());
    }

    @Qualifier(value="http")
    @Bean
    @ConfigurationProperties(prefix="hono.registry.http")
    public HttpServiceConfigProperties httpServerProperties() {
        return new HttpServiceConfigProperties();
    }

    @Bean(name={"httpServer"})
    @Scope(value="prototype")
    public DeviceRegistryHttpServer httpServer() {
        return new DeviceRegistryHttpServer();
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean httpServerFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_HTTP_SERVER);
        return factory;
    }

    @Bean
    @Scope(value="prototype")
    public AuthHandler createAuthHandler(HttpServiceConfigProperties httpServiceConfigProperties) {
        if (httpServiceConfigProperties != null && httpServiceConfigProperties.isAuthenticationRequired()) {
            return new HonoBasicAuthHandler((AuthProvider)MongoAuth.create((MongoClient)this.mongoClient(), (JsonObject)new JsonObject()), this.httpServerProperties().getRealm(), this.getTracer());
        }
        return null;
    }

    @Bean
    @Scope(value="prototype")
    public HttpEndpoint deviceHttpEndpoint() {
        MongoDbBasedDeviceBackend service = new MongoDbBasedDeviceBackend(this.registrationService(), this.credentialsService());
        return new DelegatingDeviceManagementHttpEndpoint(this.vertx(), (DeviceManagementService)service);
    }

    @Bean
    @Scope(value="prototype")
    public HttpEndpoint credentialsHttpEndpoint() {
        return new DelegatingCredentialsManagementHttpEndpoint(this.vertx(), (CredentialsManagementService)this.credentialsService());
    }

    @Bean
    @Scope(value="prototype")
    public HttpEndpoint tenantHttpEndpoint() {
        return new DelegatingTenantManagementHttpEndpoint(this.vertx(), (TenantManagementService)this.tenantService());
    }
}

